function plot_pshape(v,a,w_amp,options)

% --- Set unallocated options to default ---
if nargin < 4; options = struct(); end
if isfield(options,'title') == 0;  if isfield(options,'titlename') == 1; options.title = 1; else options.title = 0; end; end
if isfield(options,'axis_normalised') == 0; options.axis_normalised = 0; end
if isfield(options,'dataname') == 0; options.dataname = 'Plateshape'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = ''; end 
if isfield(options,'textfontsize') == 0; options.textfontsize = 20; end 
tfss = options.textfontsize;
tfsb = tfss+5;

% Plot total plate shape
phasesign = real(sign(w_amp));
phasesign(isnan(phasesign)==1) = 0;
w_amp = abs(w_amp.').*phasesign.'*1000; % from m to mm

ff=figure;
    mm_w_amp_abs = max(max(abs(w_amp)));
    [ii,jj] = find(abs(w_amp) == mm_w_amp_abs,1,'first');
    mm_w_amp = w_amp(ii,jj);
    
% Plotting normalised   
w_amp_norm = w_amp/mm_w_amp;
if options.axis_normalised == 1;contourf(v.x,v.z,w_amp_norm,30); hold on;% ,round(26-1.5*o)
    %colormap(jet)
    h = colorbar;
    caxis([-1 1])
    if min(min(w_amp_norm))<-0.01 
        if max(max(w_amp_norm))>0.01
        set(h, 'ylim', [-1 1]);
        else
        set(h, 'ylim', [-1 0]);
        end
    else
        set(h, 'ylim', [0 1]);
    end
end

% Plotting with values
if options.axis_normalised == 0
    contourf(v.x,v.z,w_amp,40); hold on;
    %colormap(jet)
    h = colorbar;
    caxis([-mm_w_amp_abs mm_w_amp_abs])
    if mm_w_amp_abs > 1; mm_w_amp_abs_rounded = round(mm_w_amp_abs,2); 
    else mm_w_amp_abs_rounded = mm_w_amp_abs;
    end
    if round(min(min(w_amp*1000))) < 0; 
        if max(max(w_amp)) >0;
        set(h, 'ylim', [-mm_w_amp_abs_rounded mm_w_amp_abs_rounded]);
        else
        set(h, 'ylim', [-mm_w_amp_abs_rounded 0]);
        end
            ytks = get(h,'YTick');
            if mm_w_amp_abs > abs(ytks(end))+0.33*abs((ytks(2)-ytks(1))); 
               ytks = [-mm_w_amp_abs_rounded ytks mm_w_amp_abs_rounded];
               set(h,'YTick',ytks);
            end
    else
        set(h, 'ylim', [0 mm_w_amp_abs_rounded]);
        ytks = get(h,'YTick');
        if mm_w_amp_abs > abs(ytks(end))+0.33*abs((ytks(2)-ytks(1))); 
            ytks = [ytks(1:end) mm_w_amp_abs_rounded];
            set(h,'YTick',ytks);
        end
    end
yl=ylabel(h,'Deflection [mm]');
set(yl,'Interpreter','Latex','Fontsize',tfsb);
end

axis equal
set(gca,'Fontsize',tfss)
xlabel('x-direction [m]','Interpreter','Latex','Fontsize',tfsb);
ylabel('z-direction [m]','Interpreter','Latex','Fontsize',tfsb);
set(gca,'TicklabelInterPreter','LaTex','Fontsize',tfss)
set(gcf, 'Color', 'w');

if options.title == 1;
    title(options.titlename,'Interpreter','Latex','Fontsize',tfsb);
end

set(gcf,'Units','Normalized','Position',[0.1 0.1 0.9 0.8])
colorbarpos=get(h,'Position');
gcapos = get(gca,'Position');
colorbarpos(3)=0.6*colorbarpos(3);
set(h,'Position',colorbarpos);
set(gca,'Position',gcapos);

if a.saveplots == 1;
        fullfoldername = fullfile(a.plotfolder,options.specificfolder);
        if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
        figurename = options.dataname;
        fullfigurename = fullfile(fullfoldername, figurename);
        export_fig(fullfigurename,'-png')
end

