function plot_pmotion(omegalin,max_w_amp,w_poi,a)
if a.plot == 1;

for i = 1:3
if a.pmotion(i) == 1
ff=figure;
%plot(omegalin,max_w_amp,'-b','LineWidth',1); hold on
plot(omegalin,omegalin.^(i-1).*max_w_amp,'-b','LineWidth',1); hold on
for j = 1:size(w_poi,2)
    plot(omegalin,omegalin.^(i-1).*w_poi(:,j).','--','LineWidth',1); hold on
end
xlim([0 max(omegalin)])
if isempty(a.pmotion_ylim) == 0;
    ylim(a.pmotion_ylim(i,:))
end
xlabel('Frequency [rad/s]','InterPreter','LaTex','Fontsize',15)
if i == 1; ylabel('Plate deflection amplitude (m)','InterPreter','LaTex','Fontsize',15); end
if i == 2; ylabel('Plate velocity amplitude (m/s)','InterPreter','LaTex','Fontsize',15); end
if i == 3; ylabel('Plate acceleration response (m/s$^2$)','InterPreter','LaTex','Fontsize',15); end
set(gca,'TicklabelInterPreter','LaTex','Fontsize',14)
grid on
legendInfo{1} = 'Plate maximum'; for j = 1:size(w_poi,2); legendInfo{j+1} = ['Point ' num2str(j) ': (' num2str(a.poi(j,1)) ',' num2str(a.poi(j,2)) ')']; end
ll=legend(legendInfo);
set(ll,'InterPreter','LaTex','Fontsize',12)
    if a.saveplots == 1;
            specificfolder = 'plateresponse';
            fullfoldername = fullfile(a.plotfolder,specificfolder);
            if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
            figurename = sprintf('%d_%d',round(min(omegalin)),round(max(omegalin)));
            fullfigurename = fullfile(a.plotfolder, specificfolder, figurename);
            export_fig(fullfigurename,'-eps','-png')
    end
end
end


%function and if end
end
end
