function [frame] = plot_fslices(v,a,cc,BprR,fshape,Omega,options)

if nargin < 7
    options = struct();
end
% --- Set unallocated options to default ---
if isfield(options,'title') == 0; 
    if isfield(options,'titlename') == 1; options.title = 1; else options.title = 0; end
end
if isfield(options,'dataname') == 0; options.dataname = 'Fluidslice'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = ''; end 
if isfield(options,'nmodes_contr') == 0; options.nmodes_contr = 1000; end


xf = v.xf;
zf = v.zf;
rhof = v.rhof;
ky = fshape.ky;
P = fshape.P;
%if a.fshape(leftright) == 3
    
%% Slice data
fprintf('Computing slice data..\n')
 Lx = xf(end);
 Lz = zf(end);
    
yslices = [0:0.2:40];
for p = 1:cc.fL.fxmodes
    for r = 1:cc.fL.fzmodes
        pr=(p-1)*cc.fL.fzmodes+r;
    for i = 1:length(yslices)
    PRy(:,:,i,pr) = P(:,:,pr).*exp(-1j*ky(pr)*yslices(i));
    end
    sumPRy(:,:,:,pr) = PRy(:,:,:,pr)*BprR(pr);  
    end
end
PRy_tot(:,:,:) = sum(sumPRy,4); % Quantified phi shape right at y = 0
pfRy = -1j*Omega*rhof*PRy_tot;
phasesign = real(sign(pfRy)); phasesign(isnan(phasesign)==1) = 0;
pfRy_amp = abs(pfRy).*phasesign;

%%
fprintf('Slice plot\n')
pfRy_amp_plot = permute(pfRy_amp,[1 3 2]);
[Z,Y,X] = meshgrid(yslices,xf,zf);

figure
yslice_plot = [0 10 20 30 40];
slice(Z,Y,X,pfRy_amp_plot/max(max(max(abs(pfRy_amp_plot)))),yslice_plot,[min(xf)],[min(zf)])
cb = colorbar;
set(cb, 'lim', [-1 1]);
caxis([-1 1])
xlabel('y-direction [m]','Interpreter','Latex','fontsize',15)
ylabel('x-direction','Interpreter','Latex','fontsize',15)
zlabel('z-direction','Interpreter','Latex','fontsize',15)
set(findobj(gca,'Type','Surface'),'EdgeColor','none');
set(gca,'ztick',[0 Lz],'xtick',[0 10 20 30 40],'ytick',[min(xf) Lx]);
set(gca,'xticklabel',{'Gates surface','10','20','30','40'});
set(gca,'zticklabel',{'Sluice bottom','Still water level'});
set(gca,'yticklabel',{'Sluice wall','Sluice wall'});
set(gca,'fontsize',14,'ticklabelinterpreter','latex')

% Plot grid
hold on; plot3([0 0],[min(xf) Lx],[0 0],'k','LineWidth',0.5);
for j = 1:length(yslice_plot)
hold on; plot3([yslice_plot(j) yslice_plot(j)],[min(xf) min(xf)],[0 Lz],'k','LineWidth',0.5);
hold on; plot3([yslice_plot(j) yslice_plot(j)],[min(xf) Lx],[0 0],'k','LineWidth',0.5);
hold on; plot3([yslice_plot(j) yslice_plot(j)],[Lx Lx],[0 Lz],'k','LineWidth',0.5);
hold on; plot3([yslice_plot(j) yslice_plot(j)],[min(xf) Lx],[Lz Lz],'k','LineWidth',0.5);
end
hold on; plot3([0 yslices(end)],[min(xf) min(xf)],[0 0],'k','LineWidth',0.5);
hold on; plot3([0 yslices(end)],[min(xf) min(xf)],[Lz Lz],'k','LineWidth',0.5);

if options.title == 1; title(options.titlename,'Interpreter','Latex','fontsize',15);
%view(148,29)
view(138,33)
axis equal
%set(gcf,'units','normalized','position',[0.1 0.2 0.8 0.6],'color','white')

set(gcf,'Units','Normalized','Position',[0 0 1 0.75],'color','white')
colorbarpos=get(cb,'Position');
gcapos = get(gca,'Position');
colorbarpos(3)=0.6*colorbarpos(3);
colorbarpos(4)=0.4*colorbarpos(4);
%colorbarpos(2)=0.1*colorbarpos(2);
colorbarpos(1)=0.85*colorbarpos(1);
set(cb,'Position',colorbarpos);
set(gca,'Position',gcapos);

drawnow

if options.title == 1;
    title(options.titlename,'Interpreter','Latex','Fontsize',18);
end

if a.saveplots == 1;
        fullfoldername = fullfile(a.plotfolder,options.specificfolder);
        if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
        figurename = options.dataname;
        fullfigurename = fullfile(fullfoldername, figurename);
        export_fig(fullfigurename,'-png','-eps')
end

frame = getframe(gcf);

end

%end