function plot_drysmodes(v,a,cc,Wkm,omegan,options)
if options.plot == 1
fprintf('Plotting structural modes..\n')
alt = 1;

if nargin < 6; options = struct(); end
if isfield(options,'specificfolder') == 0; options.specificfolder = '/system/smodes_dry/'; end 
if isfield(options,'title') == 0; options.title = 1; end 
if isfield(options,'textfontsize') == 0; options.textfontsize = 20; end 
tfss = options.textfontsize;
tfsb = tfss+5;

%% Contourplots plate modes
for km= 1:cc.smodes
        ii = figure;
        contourf(v.x,v.z,Wkm(:,:,km)',25)
        axis equal
        caxis([-1 1])
        h=colorbar;

        %% Figure labels and appearance 1
        if alt ==1
        set(gca,'Fontsize',tfss)
        xlabel('x-direction [m]','Interpreter','Latex','Fontsize',tfsb);
        ylabel('z-direction [m]','Interpreter','Latex','Fontsize',tfsb);
        set(gca,'TicklabelInterPreter','LaTex','Fontsize',tfss)
        set(gcf, 'Color', 'w');
        end

        %% Figure labels and appearance 2
        if alt == 2
        set(gca,'xtick',[],'ytick',[]);
        xlabel('L$_x$','Interpreter','Latex','Fontsize',tfsb);
        y = ylabel('$\frac{L_x}{2}$','Interpreter','Latex','Fontsize',tfsb);
        set(y,'Rotation',0)
        set(y,'Position', get(y,'Position')-[0.5,0,0]);
        set(gcf, 'Color', 'w');
        end

        omegansorted = omegan;
        if options.title == 1
            title(['Modal shape at f$_{' num2str(km) '}$ = ' num2str(round(omegan(km)/(2*pi),1)) ' Hz'],'Interpreter','Latex','Fontsize',tfsb);
        end
        
        %% Setting width colorbar and size figure
        set(gcf,'Units','Normalized','Position',[0.1 0.1 0.9 0.8])
        colorbarpos=get(h,'Position');
        gcapos = get(gca,'Position');
        colorbarpos(3)=0.6*colorbarpos(3);
        set(h,'Position',colorbarpos);
        set(gca,'Position',gcapos);
        
        %% Saving figure
        if a.saveplots == 1
                fullfoldername = fullfile(a.plotfolder,options.specificfolder);
                if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
                figurename = sprintf('Modalshape_%d',km);
                fullfigurename = fullfile(fullfoldername, figurename);
                export_fig(fullfigurename,'-png')
        end
%% End 
if a.saveplots == 1; save(fullfile(fullfoldername,'omegan.mat'),'omegan'); end

% figure loops
end
% Plot if
end
% function
end