function movie_t_pshape(wt,f,v,cc,a,optionname,optionvalue)
set(0,'DefaultFigureVisible','off')

% Maximum absolute deflection per time step
[max_wt(1,:)] = max(max(abs(wt),[],1),[],2);

% Optional arguments
if nargin < 6
    optionname = ' ';
    optionvalue = [];
end

% Start value time
starti = find(f.t>=f.addstart,1,'first')
starti = round(starti,0)

% Cut-off value time
if strcmp(optionname,'cut_off_t') == 1;
     mi = find(f.t>=optionvalue,1,'first');
end
if strcmp(optionname,'cut_off_perc') == 1;
    for i = 1:size(a.poi,1)
        wrespplot(1,:) = wt(a.poi(i,1)/cc.dx+1,a.poi(i,2)/cc.dz+1,:);
        maxwrespplot = max(abs(wrespplot));
        [d endindex(i)] = find(abs(wrespplot)/maxwrespplot>optionvalue,1,'last');
    end
    mi = max(endindex);
end

% Set new values
f.t = f.t(starti:mi);
f.amp = f.amp(starti:mi);
wt = wt(:,:,starti:mi);
max_wt = max_wt(starti:mi);
di = 5;

a.vidobj = VideoWriter([a.plotfolder 'timeresponse_plateshape_' datestr(now,'mmmm_dd_HH_MM') '.avi']);
a.vidobj.FrameRate = 30*0.5*length(f.t)/di*(f.t(2)-f.t(1));
open(a.vidobj);

wtpoi(1,:) = real(wt(a.poi(1,1)/cc.dx+1,a.poi(1,2)/cc.dz+1,:));

% %% Plotting shape
% ff=figure;
% for i = 1:di:size(wt,3)
% set(gcf, 'units','normalized','outerposition',[0 0 1 1]);
% subplot(6,1,1)
% plot(f.t,f.amp,'-k','LineWidth',1); hold on
% plot(f.t(i),f.amp(i),'*','color',[0.5 0.5 0.5],'LineWidth',0.5); hold on
% plot([f.t(i) f.t(i)],[min(f.amp) max(f.amp)],'--','color',[0.5 0.5 0.5],'LineWidth',0.2); hold off
% xlim([min(f.t) max(f.t)]);
% ylim([min(f.amp) max(f.amp)]);
% set(gca,'ytick',[min(f.amp) (min(f.amp)+max(f.amp))/2 max(f.amp)]);
% grid on
% 
% subplot(6,1,2)
% plot(f.t,max_wt,'-k','LineWidth',1); hold on
% plot(f.t(i),max_wt(i),'*','color',[0.5 0.5 0.5],'LineWidth',0.5); hold on
% plot(f.t,wtplot,'--k','LineWidth',1); hold on
% plot(f.t(i),wtplot(i),'*','color',[0.5 0.5 0.5],'LineWidth',0.5); hold on
% plot([f.t(i) f.t(i)],[min(max_wt) max(max_wt)],'--','color',[0.5 0.5 0.5],'LineWidth',0.2); hold on
% xlim([min(f.t) max(f.t)]);
% ylim([min([min(max_wt) min(wtplot)]) max([max(wtplot) max(max_wt)]); hold off
% set(gca,'ytick',[min(max_wt) (min(max_wt)+max(max_wt))/2 max(max_wt)]);
% grid on

%% Plotting shape
ff=figure;
for i = 1:di:size(wt,3)
set(gcf, 'units','normalized','outerposition',[0 0 1 1]);
subplot(6,1,1)
plot(f.t,f.amp,'-k','LineWidth',1); hold on
plot(f.t(i),f.amp(i),'*','color',[0.5 0.5 0.5],'LineWidth',0.5); hold on
plot([f.t(i) f.t(i)],[min(f.amp) max(f.amp)],'--','color',[0.5 0.5 0.5],'LineWidth',0.2); hold off
xlim([min(f.t) max(f.t)]);
ylim([min(f.amp) max(f.amp)]);
set(gca,'ytick',[min(f.amp) (min(f.amp)+max(f.amp))/2 max(f.amp)]);
grid on

subplot(6,1,[2 3])
minwy = min([min(max_wt) min(wtpoi)]);
maxwy = max([max(wtpoi) max(max_wt)]);
ylim([minwy maxwy]); hold off
plot(f.t,max_wt,'-k','LineWidth',1); hold on
plot(f.t,wtpoi,'--k','LineWidth',1); hold on
plot(f.t(i),max_wt(i),'*','color',[0.5 0.5 0.5],'LineWidth',0.5); hold on
plot(f.t(i),wtpoi(i),'*','color',[0.5 0.5 0.5],'LineWidth',0.5); hold on
plot([f.t(i) f.t(i)],[minwy maxwy],'--','color',[0.5 0.5 0.5],'LineWidth',0.2); hold off
xlim([min(f.t) max(f.t)]);
%ylim([min(max_wt) max(max_wt)]);
set(gca,'ytick',[minwy 0 maxwy/2 maxwy]);
legendi{1} = '|Maximum| on the plate';
legendi{2} = ['Loc. (x,z) = (' num2str(a.poi(1,1)) ',' num2str(a.poi(1,2)) ') m'];
legend(legendi)
grid on

phasesign = real(sign(wt(:,:,i)));
phasesign(isnan(phasesign)==1) = 0;
subplot(6,1,[4 5 6])
title(['Abs(deflection)*sign, t = ' num2str(f.t(i))]);
[hC hC] = contourf(v.xs,v.zs,abs(wt(:,:,i).').*phasesign.',25); hold on; % ,round(26-1.5*o)
h = colorbar;
set(gca,'CLim',[-max(max(max(abs(wt)))) max(max(max(abs(wt))))]);
set(hC,'LineColor',[0.5 0.5 0.5]);
axis equal
colormap(jet)

clc; fprintf('Writing frame %d/%d\n',round((i+1)/di),round((size(wt,3)+1)/di));
ax = gca;
ax.NextPlot = 'replaceChildren';
frame = getframe(gcf);
writeVideo(a.vidobj,frame)
close all;
end

set(0,'DefaultFigureVisible','on')

%% backup
% title('Real(deflection)')
% [hC hC] = contourf(v.xs,v.zs,real(wt(:,:,i).'),25); hold on; % ,round(26-1.5*o)
% h = colorbar;
% set(gca,'CLim',[-max(max(max(abs(wt)))) max(max(max(abs(wt))))]);
% set(hC,'LineColor',[0.5 0.5 0.5]);
% axis equal
% %subplot(1,3,2)
% title('Imag(deflection)')
% [hC hC] = contourf(v.xs,v.zs,imag(wt(:,:,i).'),25); hold on; % ,round(26-1.5*o)
% h = colorbar;
% set(gca,'CLim',[-max(max(max(abs(wt)))) max(max(max(abs(wt))))]);
% set(hC,'LineColor',[0.5 0.5 0.5]);
% axis equal
% colormap(jet)
% subplot(1,3,3)