function [f] = forceshape_distributed_square(v,cc,f,leftbottom,righttop,F_amp)
if nargin < 5
  error('input_example: structures `v`,`cc`, and `a` are required input')
elseif nargin < 6
    F_amp = 1;
end

% Coordinate vectors
v.xs = 0:cc.dx:v.Lx;
v.zs = 0:cc.dz:v.Lz;

f.F = zeros(length(v.xs),length(v.zs),1,1);
for i = 1:length(v.xs)
    for j = 1:length(v.zs)
        if v.xs(i) >= leftbottom(1) && v.zs(j) >= leftbottom(2) && v.xs(i) <= righttop(1) && v.zs(j) <=righttop(2)
            f.F(i,j,1,1) = F_amp;
            % Reducing amplitude at edge elements so that the central differences integral gives the correct results 
            if or(v.xs(i) == righttop(1),v.zs(j) == leftbottom(2))
                f.F(i,j,1,1) = F_amp/2;
            end
        end
    end
end
     
end