%% Case information

%% Parameters
% Structural geometry parameters
%v.Lx = 13; % Gate width [m]
%v.Lz = 7.5; % Gate height [m]

%Parameter Input
v.Lengte = v.V(v.var,2);     
v.Hoogte = v.V(v.var,3);    
v.Hoogte2 = v.V(v.var,5);    
v.Hoogte3 = v.Lz;
v.Lengte2 = v.V(v.var,4);      
v.Lengte3 = v.V(v.var,6);
if v.V(v.var,12) == 1
    v.Stijfheid = 300000000000;                    %Left constraint
else
    v.Stijfheid = 0;
end
if v.V(v.var,13) == 1
    v.Stijfheid2 = 300000000000;                    %Bottom constraint
else
    v.Stijfheid2 = 0;
end
if v.V(v.var,14) == 1
    v.Stijfheid3 = 300000000000;                    %Right constraint
else
    v.Stijfheid3 = 0;
end
if v.V(v.var,15) == 1
    v.Stijfheid4 = 300000000000;                    %Top constraint
else
    v.Stijfheid4 = 0;
end
v.Plaatdikte = v.V(v.var,1);                         %[m]
v.LengthHorRibs = v.V(v.var,16);                        %[m]
v.LengthVertRibs = v.V(v.var,17);
v.RibThicknessHor = v.V(v.var,10);
v.RibThicknessHor2 = v.V(v.var,11);
v.RibThicknessHor3 = v.V(v.var,11);
v.RibThicknessHor4 = v.V(v.var,10);
v.RibThicknessVert = v.V(v.var,7);
v.RibThicknessVert2 = v.V(v.var,8);
v.RibThicknessVert3 = v.V(v.var,9);
v.RibThicknessVert4 = v.V(v.var,8);
v.Lengte4 = v.Lx;
v.RibThicknessVert5 = v.V(v.var,7);

%If new parameter is added; section directly below needs to be updated
if v.case == 1
    v.Sizes = [length(v.Lengte), length(v.Hoogte), length(v.Hoogte2), length(v.Hoogte3), length(v.Lengte2), length(v.Lengte3), length(v.Stijfheid), length(v.Stijfheid2), length(v.Stijfheid3), length(v.Stijfheid4), length(v.Plaatdikte), length(v.LengthHorRibs), length(v.LengthVertRibs), length(v.RibThicknessHor), length(v.RibThicknessVert), length(v.Lengte4), length(v.RibThicknessVert5)];
    v.Loop = length(v.Lengte)* length(v.Hoogte)* length(v.Hoogte2)* length(v.Hoogte3)* length(v.Lengte2)* length(v.Lengte3)* length(v.Stijfheid)* length(v.Stijfheid2)* length(v.Stijfheid3)* length(v.Stijfheid4)* length(v.Plaatdikte)* length(v.LengthHorRibs)* length(v.LengthVertRibs)* length(v.RibThicknessHor)* length(v.RibThicknessVert)* length(v.Lengte4)* length(v.RibThicknessVert5);
    v.Par = zeros(length(v.Sizes),max(v.Sizes));
    v.Par(1,1:length(v.Lengte)) = v.Lengte; v.Par(2,1:length(v.Hoogte)) = v.Hoogte; v.Par(3,1:length(v.Hoogte2)) = v.Hoogte2; v.Par(4,1:length(v.Hoogte3)) = v.Hoogte3; v.Par(5,1:length(v.Lengte2)) = v.Lengte2; v.Par(6,1:length(v.Lengte3)) = v.Lengte3; v.Par(7,1:length(v.Stijfheid)) = v.Stijfheid; v.Par(8,1:length(v.Stijfheid2)) = v.Stijfheid2; v.Par(9,1:length(v.Stijfheid3)) = v.Stijfheid3; v.Par(10,1:length(v.Stijfheid4)) = v.Stijfheid4; v.Par(11,1:length(v.Plaatdikte)) = v.Plaatdikte; v.Par(12,1:length(v.LengthHorRibs)) = v.LengthHorRibs; v.Par(13,1:length(v.LengthVertRibs)) = v.LengthVertRibs; v.Par(14,1:length(v.RibThicknessHor)) = v.RibThicknessHor; v.Par(15,1:length(v.RibThicknessVert)) = v.RibThicknessVert; v.Par(16,1:length(v.Lengte4)) = v.Lengte4; v.Par(17,1:length(v.RibThicknessVert5)) = v.RibThicknessVert5; 
elseif v.case == 2
    v.Sizes = [length(v.Lengte), length(v.Hoogte), length(v.Hoogte2), length(v.Hoogte3), length(v.Lengte2), length(v.Lengte3), length(v.Stijfheid), length(v.Stijfheid2), length(v.Stijfheid3), length(v.Stijfheid4), length(v.Plaatdikte), length(v.LengthHorRibs), length(v.LengthVertRibs), length(v.RibThicknessHor), length(v.RibThicknessHor2), length(v.RibThicknessHor3), length(v.RibThicknessVert), length(v.Lengte4), length(v.RibThicknessVert5)];
    v.Loop = length(v.Lengte)* length(v.Hoogte)* length(v.Hoogte2)* length(v.Hoogte3)* length(v.Lengte2)* length(v.Lengte3)* length(v.Stijfheid)* length(v.Stijfheid2)* length(v.Stijfheid3)* length(v.Stijfheid4)* length(v.Plaatdikte)* length(v.LengthHorRibs)* length(v.LengthVertRibs)* length(v.RibThicknessHor)* length(v.RibThicknessHor2)* length(v.RibThicknessHor3)* length(v.RibThicknessVert)* length(v.Lengte4)* length(v.RibThicknessVert5);
    v.Par = zeros(length(v.Sizes),max(v.Sizes));
    v.Par(1,1:length(v.Lengte)) = v.Lengte; v.Par(2,1:length(v.Hoogte)) = v.Hoogte; v.Par(3,1:length(v.Hoogte2)) = v.Hoogte2; v.Par(4,1:length(v.Hoogte3)) = v.Hoogte3; v.Par(5,1:length(v.Lengte2)) = v.Lengte2; v.Par(6,1:length(v.Lengte3)) = v.Lengte3; v.Par(7,1:length(v.Stijfheid)) = v.Stijfheid; v.Par(8,1:length(v.Stijfheid2)) = v.Stijfheid2; v.Par(9,1:length(v.Stijfheid3)) = v.Stijfheid3; v.Par(10,1:length(v.Stijfheid4)) = v.Stijfheid4; v.Par(11,1:length(v.Plaatdikte)) = v.Plaatdikte; v.Par(12,1:length(v.LengthHorRibs)) = v.LengthHorRibs; v.Par(13,1:length(v.LengthVertRibs)) = v.LengthVertRibs; v.Par(14,1:length(v.RibThicknessHor)) = v.RibThicknessHor; v.Par(15,1:length(v.RibThicknessHor2)) = v.RibThicknessHor2; v.Par(16,1:length(v.RibThicknessHor3)) = v.RibThicknessHor3; v.Par(17,1:length(v.RibThicknessVert)) = v.RibThicknessVert; v.Par(18,1:length(v.Lengte4)) = v.Lengte4; v.Par(19,1:length(v.RibThicknessVert5)) = v.RibThicknessVert5; 
else
    v.Sizes = [length(v.Lengte), length(v.Hoogte), length(v.Hoogte2), length(v.Hoogte3), length(v.Lengte2), length(v.Lengte3), length(v.Stijfheid), length(v.Stijfheid2), length(v.Stijfheid3), length(v.Stijfheid4), length(v.Plaatdikte), length(v.LengthHorRibs), length(v.LengthVertRibs), length(v.RibThicknessHor), length(v.RibThicknessHor2), length(v.RibThicknessHor3), length(v.RibThicknessHor4), length(v.RibThicknessVert), length(v.RibThicknessVert2), length(v.RibThicknessVert3), length(v.RibThicknessVert4), length(v.Lengte4), length(v.RibThicknessVert5)];
    v.Loop = length(v.Lengte)* length(v.Hoogte)* length(v.Hoogte2)* length(v.Hoogte3)* length(v.Lengte2)* length(v.Lengte3)* length(v.Stijfheid)* length(v.Stijfheid2)* length(v.Stijfheid3)* length(v.Stijfheid4)* length(v.Plaatdikte)* length(v.LengthHorRibs)* length(v.LengthVertRibs)* length(v.RibThicknessHor)* length(v.RibThicknessHor2)* length(v.RibThicknessHor3)* length(v.RibThicknessHor4)* length(v.RibThicknessVert)* length(v.RibThicknessVert2)* length(v.RibThicknessVert3)* length(v.RibThicknessVert4)* length(v.Lengte4)* length(v.RibThicknessVert5);
    v.Par = zeros(length(v.Sizes),max(v.Sizes));
    v.Par(1,1:length(v.Lengte)) = v.Lengte; v.Par(2,1:length(v.Hoogte)) = v.Hoogte; v.Par(3,1:length(v.Hoogte2)) = v.Hoogte2; v.Par(4,1:length(v.Hoogte3)) = v.Hoogte3; v.Par(5,1:length(v.Lengte2)) = v.Lengte2; v.Par(6,1:length(v.Lengte3)) = v.Lengte3; v.Par(7,1:length(v.Stijfheid)) = v.Stijfheid; v.Par(8,1:length(v.Stijfheid2)) = v.Stijfheid2; v.Par(9,1:length(v.Stijfheid3)) = v.Stijfheid3; v.Par(10,1:length(v.Stijfheid4)) = v.Stijfheid4; v.Par(11,1:length(v.Plaatdikte)) = v.Plaatdikte; v.Par(12,1:length(v.LengthHorRibs)) = v.LengthHorRibs; v.Par(13,1:length(v.LengthVertRibs)) = v.LengthVertRibs; v.Par(14,1:length(v.RibThicknessHor)) = v.RibThicknessHor; v.Par(15,1:length(v.RibThicknessHor2)) = v.RibThicknessHor2; v.Par(16,1:length(v.RibThicknessHor3)) = v.RibThicknessHor3; v.Par(17,1:length(v.RibThicknessHor4)) = v.RibThicknessHor4; v.Par(18,1:length(v.RibThicknessVert)) = v.RibThicknessVert; v.Par(19,1:length(v.RibThicknessVert2)) = v.RibThicknessVert2; v.Par(20,1:length(v.RibThicknessVert3)) = v.RibThicknessVert3; v.Par(21,1:length(v.RibThicknessVert4)) = v.RibThicknessVert4; v.Par(22,1:length(v.Lengte4)) = v.Lengte4; v.Par(23,1:length(v.RibThicknessVert5)) = v.RibThicknessVert5; 
end
    
v.Totaltime = v.Loop*2;
v.SizesM = [];
for i = 2:length(v.Sizes)
    v.SizesM(1) = v.Sizes(1);
    v.SizesM(i) = v.Sizes(i)*v.SizesM(i-1);
end

% location of the points of deflection needed for stresscalculation in SCIA
v.stressx =[round(v.Lengte/cc.dx)+1, round(v.Lengte2/cc.dx)+1, round(v.Lengte3/cc.dx)+1];
v.stressz = [1, round(v.Hoogte/cc.dx)+1, round(v.Hoogte2/cc.dx)+1];

v.sx = [];          %xloc (node) for the more detailed predef SCIA model (parametric)
v.sz = [];          %yloc (node)
k = 0;
for i = 1:15
    for j = 1:25
        v.sx(k+j) = 5*j+1;
        v.sz(k+j) = 75-(i*5)+1;
        a.pod(k+j,1) = v.sx(k+j);
        a.pod(k+j,2) = v.sz(k+j);
    end
    k = k + j;
end

v.dispx = [];          %xloc for predef SCIA model (WiBo)
v.dispz = [];          %yloc
k = 0;
for i = 1:14
    for j = 1:19
        v.dispx(k+j) = 0.6*(j)+0.565;
        if i < 13
            v.dispz(k+j) = 2.650-(i*0.5);
        end
        if i > 12
            v.dispz(k+j) = -3.730-(i-13)*0.52;
        end
        %a.pod(k+j,1) = v.sx(k+j);
        %a.pod(k+j,2) = v.sz(k+j);
    end
    k = k + j;
end

% Save the names of the parameters for SCIA in matrix
names = fieldnames(v);
for i = 4:(length(v.Sizes)+3)
    ParNames(i-3) = string(names{i});
end