function [out,v,a,f] = model_main_twodom_dry(v,cc,a,f,modes)

%% Start values
startt=tic;
[a,v] = model_defaultoutput(a,v); % default all values that have not been passed in the set-file
model_checktoolboxes({'MATLAB'; 'Optimization_Toolbox'; 'PDE_Toolbox'; 'Statistics_Toolbox'; 'Symbolic_Toolbox'})

%% Parameters and settings
% Coordinate vectors structure
v.x = 0:cc.dx:v.Lx;
v.z = 0:cc.dz:v.Lz;

%% Input modes
Wxz = modes.Wxz; Wx = modes.Wx; Wz = modes.Wz; omegan = modes.omegan; clear modes;
omegan = omegan(1:cc.smodes,1:cc.smodes);

%% START OMEGA INDEPENDENT PART
%% Integrals and matrices dependent on the structure
% Integration constant structural modes
for k = 1:cc.smodes
    for m = 1:cc.smodes
        GW(k,m) = trapz(v.x,(trapz(v.z,Wxz(:,:,k,m).^2,2)));
    end
end
GW = reshape(GW.',1,cc.smodes^2).';

% Matrix intertia plate modes
omegan = reshape(omegan.',1,cc.smodes^2).';
IBM = diag(v.rhos*omegan.^2.*GW);

% Matrix damping plate modes
CBM_c = diag(1j*v.cdamp*GW);

%% External force
fprintf('Determining modal forces...\n')

% Modal force 
if a.forceintervals == 0
    if a.F==1; plot_force(v.x,v.z,f,a); end
    for l = 1:cc.smodes
       for n = 1:cc.smodes
           ln = (l-1)*cc.smodes+n;
           Fln(ln) = trapz(v.x,trapz(v.z,f.F(:,:).*Wxz(:,:,l,n),2));
       end
    end
elseif a.forceintervals == 1
    for ivn = 1:f.n_iv
        ii_iv = f.ii_iv;
        f.F = f.interval(ivn).F;
        for l = 1:cc.smodes
           for n = 1:cc.smodes
               ln = (l-1)*cc.smodes+n;
               Fln(ln) = trapz(v.x,trapz(v.z(ii_iv(ivn):ii_iv(ivn+1)),f.F(:,ii_iv(ivn):ii_iv(ivn+1)).*Wxz(:,ii_iv(ivn):ii_iv(ivn+1),l,n),2));
           end
        end
        Fln_iv(:,ivn) = Fln(:);
    end
%     Wkones = ones(size(Wkm));
%     Fln_check = trapz(v.x,trapz(v.z(ii_iv(ivn):ii_iv(ivn+1)),f.F(:,ii_iv(ivn):ii_iv(ivn+1)).*Wkones(:,ii_iv(ivn):ii_iv(ivn+1),l,n),2));
end

%% START OMEGA DEPENDENT PART
fprintf('Starting calculation of the gate fluid system for %d frequencies...\n',length(f.omegavec))

for o = 1:length(f.omegavec)
tstartloop=tic;
Omega = f.omegavec(o);

%% Filling matrices

% Structural intertia, stiffness
IBE = diag(v.rhos*Omega^2*GW);

% Viscous damping
CBM = Omega*CBM_c;

%% Constructing total matrix and determination of modal coefficients
FLR = 0;
FLL = 0;
M = IBM-IBE+CBM+FLR+FLL;

% Solve matrix (per force interval including the complex fourier amplitude or in total)
if a.forceintervals == 1
    for i = 1:f.n_iv
        Fln_vec(1,:) = Fln_iv(:,i);
        Aln_iv(:,i) = Fln_vec/M;
        Aln_iv_ifft(:,i) = Aln_iv(:,i)*f.interval(i).Y0(o);
    end
    Aln = sum(Aln_iv_ifft,2);
else
    Aln = Fln/M;
end

% Restructure Akm (can be better written as resize function)
for k = 1:cc.smodes
    for m = 1:cc.smodes
    km = (k-1)*cc.smodes+m;
    Akm(k,m) = Aln(km);
    end
end


if a.fft == 0
    for k = 1:cc.smodes
        for m = 1:cc.smodes
            km = (k-1)*cc.smodes+m;
            Wmodes(:,:,km) = Akm(k,m)*Wxz(:,:,k,m);
        end
    end
    w = sum(Wmodes,3);
    w_abs = abs(w); % absolute value of summed quantified mode contributions;
else
    Akm_H(:,:,o) = Akm; %
end % frequency response

%% Plot plate shapes
if a.wetsmodes.plot >= 1
    a.wetsmodes.dataname = ['Modalshape_' num2str(o)]; a.wetsmodes.titlename = ['Resonance shape at $f_{' num2str(o) '}$ = ' num2str(round(Omega/(2*pi),1)) ' Hz'];
    plot_pshape(v,a,w,a.wetsmodes);
end
if a.wetsmodes.plot(1) >= 2
    a.wetsmodes.dataname = ['Modalcontributions_' num2str(o)]; a.wetsmodes.titlename =['Contributions modal shapes at $\omega_{' num2str(o) '}$ = ' num2str(round(Omega/(2*pi),1)) ' Hz'];
    plot_pshape_contr(a,Akm,a.wetsmodes);
end
if a.pshape.plot >= 1;  plot_pshape(v,a,w,a.pshape); end
if a.pshape.plot >= 2;  plot_pshape_contr(a,Akm,a.pshape); end

%% Analysis per frequency - structural
if a.pstress.calc == 1
    v.D = real(v.D); % Use real part of bending rigidity

    [FZ(:,:),FX(:,:)]=gradient(w_abs,v.z,v.x); %dw/dz(x,z) and dw/dx(x,z)
    FZ(:,end) = FZ(:,end-1)+(FZ(:,end-1)-FZ(:,end-2)) + ((FZ(:,end-1)-FZ(:,end-2))-(FZ(:,end-2)-FZ(:,end-3)));
    FZ(:,1) = FZ(:,2)+(FZ(:,2)-FZ(:,3)) + ((FZ(:,2)-FZ(:,3))-(FZ(:,3)-FZ(:,4)));
    [k_zz(:,:),k_xz(:,:)] = gradient(FZ,v.z,v.x); % dw^2/dz^2, dw^2/dxdz
    k_zz(:,end) = k_zz(:,end-1)+(k_zz(:,end-1)-k_zz(:,end-2)) + ((k_zz(:,end-1)-k_zz(:,end-2))-(k_zz(:,end-2)-k_zz(:,end-3)));
    k_zz(:,1) = k_zz(:,2)+(k_zz(:,2)-k_zz(:,3)) + ((k_zz(:,2)-k_zz(:,3))-(k_zz(:,3)-k_zz(:,4)));
    [~,k_xx(:,:)] = gradient(FX,v.z,v.x); % dw^2/dx^2

    sigma_xx = -v.D*v.thy/v.I*(k_xx + v.nu*k_zz);
    sigma_zz = -v.D*v.thy/v.I*(v.nu*k_xx + k_zz); 
    tau_xz = -v.D*v.thy/v.I*(1-v.nu)*(k_xz);

    out.sigma_v = sqrt(sigma_xx.^2 - sigma_xx.*sigma_zz + sigma_zz.^2 + 3*tau_xz.^2);
    out.sigma_v_max(o) = max(max(abs(out.sigma_v)));
end
if a.pstress.plot == 1
    plot_pstress(v,a,out.sigma_v,a.pstress);
end

%% Plate deflection per frequency
% Maximum plate's deflection
if any(a.pmotion) == 1
    max_w_amp(o) = max(max(w_abs)); % plate's maximum deflection on any location, different for each omega
    for i = 1:size(a.poi,1)
    w_poi(o,i) = w_abs(round(a.poi(i,1)/cc.dx+1),round(a.poi(i,2)/cc.dz+1)); % plate's deflection at poi's
    end
end

%% Time left
tloop(o)=toc(tstartloop);
if a.freqmovie == 1
tmovdiff= tloop(o)-tmovie;
tmov = [tmovie tmovdiff a.tcomp1 a.tcomp2 a.tcomp3 a.tplot a.tsave];
disp(tmov)
end
if o == 13
    timeremainminprev = timeremainmin;
    timeremainsev.cprev = timeremainsec;
end
if o>13
    timeremainminprev = min(timeremainmin,timeremainminprev);
    timeremainsev.cprev = min(timeremainsec,timeremainsev.cprev);
end
if o>11
    tloopa = sum(tloop(end-10:end))/11;
    timeremainmin = round(tloopa*(length(f.omegavec)-o)/60);
    timeremainsec = round(tloopa*(length(f.omegavec)-o));
end
if o>12
    if or(timeremainmin < timeremainminprev,o==13) || timeremainsec < 181
        if timeremainsec > 180
            clc;fprintf('Time past: %i [min] \n',round(sum(tloop)/60))
            fprintf('Estimated time remaining: %d [min]\n',timeremainmin)
        else
            if timeremainsec < timeremainsev.cprev
                clc;fprintf('Time past: %i [min] \n',round(sum(tloop)/60))
                fprintf('Estimated time remaining: %d:%02d [min]\n', floor(timeremainsec/60),rem(timeremainsec,60))
            end
        end
    end
end
   
end % End omega loop    
fprintf('Calculation finished\n')

%% Frequency analysis after
% Find natural frequencies by peaks.
if a.pks == 1; omegapks = omegapeaks(f.omegavec,max_w_amp); end

% Plotting plate's motion over frequency range (max and poi's)
if isempty(a.poi) == 1; w_poi = []; end
if (any(a.pmotion == 1) == 1); plot_pmotion(f.omegavec,max_w_amp,w_poi,a); end

% Plotting fluid's motion over frequency range (max and poi's)
if isempty(a.poi) == 1; pfL_poi = []; pfR_poi = []; end
if a.fmotion(1) == 1; leftright = 1; plot_fmotion(f.omegavec,max_pfL_amp,pfL_poi,leftright,a); end
if a.fmotion(2) == 1; leftright = 2; plot_fmotion(f.omegavec,max_pfR_amp,pfR_poi,leftright,a); end

%% Passing all requested parameters to out. structure and .mat file
calc_time = toc(startt); a.outputpar = [a.outputpar, {'calc_time'}];
for i = 1:length(a.outputpar); out.(genvarname(a.outputpar{i})) = eval(genvarname(a.outputpar{i})); end

% Saving requested variables
if isempty(a.outputpar) == 0; save(['.\results\' a.casecode '.mat'],a.outputpar{:}); end
if a.saveresults == 1; save(['.\results\' a.casecode '_casepars.mat'],'a','f','cc','v','out'); end

%% Subfunctions
function [omegapks] = omegapeaks(omegalin,max_w_amp)
[~,pksmax] = findpeaks(max_w_amp);
if length(pksmax)>=1
    for i = 1:length(pksmax)
    omegapks(i) = omegalin(pksmax(i));
    end
else
    omegapks = 'No peaks founds';
end