function [f] = data_2Dv_changetimestep(f,dt_req)

dt = f.t(2)-f.t(1);
if dt < dt_req
    fprintf('Changing time step of data from %f s to %f s.. \n',dt,dt_req)
factor = dt_req/dt;
factor_rounded = round(factor);
res = mod(factor,factor_rounded);
if res >= 10^-10
    error('No integer factor between orginal and new time step')
end
f.p = f.p(1:factor_rounded:end,:);
f.t = f.t(1:factor_rounded:end);
else
    fprintf('Time step requested is smaller than original. Time step is not changed.\n')
end
