function [f] = data_2Dv_addriseandfall(f,trise,tfall)
fprintf('Adding rise and fall to force data..\n')

n_timesteps = size(f.p,1);
n_measurepoints = size(f.p,2);
dt = f.t(2)-f.t(1);

n_add_timesteps_rise = round(trise/dt);
n_add_timesteps_fall = round(tfall/dt);

n_timesteps_new = n_add_timesteps_rise + n_timesteps + n_add_timesteps_fall;

pn = zeros(n_timesteps_new,n_measurepoints);

for n = 1:n_measurepoints
    pstart = f.p(1,n);
    pend = f.p(end,n);
    for i = 1:n_add_timesteps_rise
        pn(i,n) = pstart*i/n_add_timesteps_rise;
    end
    pn(n_add_timesteps_rise+1:n_add_timesteps_rise+n_timesteps,n) = f.p(:,n);
    for i = n_add_timesteps_rise+n_timesteps+1:n_add_timesteps_rise+n_timesteps+n_add_timesteps_fall
        pn(i,n) = pend-pend*(i-n_add_timesteps_rise-n_timesteps)/n_add_timesteps_fall;
    end
end

tn = linspace(f.t(1)-trise,f.t(end)+tfall,n_timesteps_new);

f.p = pn;
f.t = tn;


