function plot_pstress(v,a,sigma,options)

% --- Set unallocated options to default ---
if nargin < 4; options = struct(); end
if isfield(options,'title') == 0;  if isfield(options,'titlename') == 1; options.title = 1; else options.title = 0; end; end
if isfield(options,'axis_normalised') == 0; options.axis_normalised = 0; end
if isfield(options,'dataname') == 0; options.dataname = 'Platestress'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = ''; end 
if isfield(options,'ylabelname') == 0; options.ylabelname = 'Stress [N/mm$^2$]'; end 
if isfield(options,'textfontsize') == 0; options.textfontsize = 20; end 
tfss = options.textfontsize;
tfsb = tfss+5;

if options.plot == 1

% Plot total plate shape
phasesign = real(sign(sigma));
phasesign(isnan(phasesign)==1) = 0;
sigma = abs(sigma.').*phasesign.'/10^6;

ff=figure;
mm_sigma = max(max(abs(sigma)));
if mm_sigma>1; mm_sigma_rounded = round(mm_sigma,0); else mm_sigma_rounded = mm_sigma; end
[ii,jj] = find(abs(sigma) == mm_sigma,1,'first');
mm_sigma = sigma(ii,jj);
contourf(v.x,v.z,sigma,30);
h = colorbar;
set(h, 'ylim', [0 mm_sigma_rounded]);
%colormap(jet)
caxis([-abs(mm_sigma) abs(mm_sigma)]) 


ytks = get(h,'YTick');
if mm_sigma > abs(ytks(end))+0.33*abs((ytks(2)-ytks(1))); 
    if mm_sigma_rounded>ytks(end); ytks = [ytks mm_sigma_rounded]; end
    set(h,'YTick',ytks);
end

axis equal
set(gca,'Fontsize',14)
yl=ylabel(h,options.ylabelname);
set(yl,'Interpreter','Latex','Fontsize',tfsb);   
xlabel('x-direction [m]','Interpreter','Latex','Fontsize',tfsb);
ylabel('z-direction [m]','Interpreter','Latex','Fontsize',tfsb);
set(gcf, 'Color', 'w');
set(gca,'Ticklabelinterpreter','Latex','Fontsize',tfss)

if options.title == 1;
    title(options.titlename,'Interpreter','Latex','Fontsize',tfsb);
end

set(gcf,'Units','Normalized','Position',[0.1 0.1 0.9 0.8])
colorbarpos=get(h,'Position');
gcapos = get(gca,'Position');
colorbarpos(3)=0.6*colorbarpos(3);
set(h,'Position',colorbarpos);
set(gca,'Position',gcapos);

    if a.saveplots == 1;
            fullfoldername = fullfile(a.plotfolder,options.specificfolder);
            if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
            figurename = options.dataname;
            fullfigurename = fullfile(fullfoldername, figurename);
            export_fig(fullfigurename,'-png')
    end
end