%% Plotting solution for Omega

% Relative contributions of Akm
plotsmodes = 3;
[KK,MM] = meshgrid(1:1:plotsmodes,1:1:plotsmodes);
Akmp = Akm(1:plotsmodes,1:plotsmodes);
Akmtot = sum(sum(abs(Akmp)));
ff=figure;
h=bar3(abs(Akmp)/Akmtot*100);
%colorbar;
for n=1:numel(h) 
    cdata=get(h(n),'zdata'); 
    set(h(n),'cdata',cdata,'facecolor','interp');
end
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)
title(['$\omega_ ' num2str(o) '$ = ' num2str(round(Omega)) ' rad/s'],'Interpreter','Latex','Fontsize',18)
ylabel('Mode k (x-direction)','InterPreter','LaTex','Fontsize',17)
xlabel('Mode m (z-direction)','InterPreter','LaTex','Fontsize',17)
zlabel('Relative contribution [$\%$]','InterPreter','LaTex','Fontsize',17)
zlim([0 100])
    if savingplots ==2;
            specificfolder = sprintf('Plateresponse');
            figurename = sprintf('allshapecontributions%d_fext%d',o,fext);
            fullfigurename = fullfile(outputfigures, specificfolder, figurename);
            saveas(ff,fullfigurename,'epsc')
    end

% Plot total plate shape
ff=figure;
contourf(xs,zs,Wtotabs'/max(max(Wtotabs)),round(26-1.5*o)); hold on;
h = colorbar;
set(h, 'ylim', [0 1]);
colormap(jet)
axis equal
title(['Plate shape at $\omega_ ' num2str(o) '$ = ' num2str(round(Omega)) ' rad/s'],'Interpreter','Latex','Fontsize',18)
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)
caxis([-1 1])
    if savingplots == 2;
            specificfolder = sprintf('Plateresponse');
            figurename = sprintf('alleigenshape%d_fext%d',o,fext);
            fullfigurename = fullfile(outputfigures, specificfolder, figurename);
            saveas(ff,fullfigurename,'epsc')
    end

% Plot fluid total shapes
% Fluid left
ff=figure;
contourf(xf,zfR,transpose(pftotalabsR)/max(max(pftotalabsR)),30-o)
hold on
h=colorbar;
set(h, 'ylim', [0 1]);
colormap(jet)
axis equal
title(['Fluid pressure shape (north) at $\omega_ ' num2str(o) '$ = ' num2str(round(Omega)) ' rad/s'],'Interpreter','Latex','Fontsize',18)
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)
caxis([-1 1])
    if savingplots == 2;
            specificfolder = sprintf('Plateresponse');
            figurename = sprintf('fluidpressureR_%d',o);
            fullfigurename = fullfile(outputfigures, specificfolder, figurename);
            saveas(ff,fullfigurename,'epsc')
    end
    
% Fluid right    
ff=figure;
contourf(xf,zfL,transpose(pftotalabsL)/max(max(pftotalabsL)),30-o)
h=colorbar;
set(h, 'ylim', [0 1]);
colormap(jet)
axis equal
title(['Fluid pressure shape (south) at $\omega_ ' num2str(o) '$ = ' num2str(round(Omega)) ' rad/s'],'Interpreter','Latex','Fontsize',18)
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)
caxis([-1 1])
    if savingplots == 2;
            specificfolder = sprintf('Plateresponse');
            figurename = sprintf('fluidpressureL_%d',o);
            fullfigurename = fullfile(outputfigures, specificfolder, figurename);
            saveas(ff,fullfigurename,'epsc')
    end
 