function plot_fmotion(omegalin,max_pf_amp,pf_poi,leftright,a)


ff=figure;
plot(omegalin,max_pf_amp,'-b','LineWidth',1); hold on
for i = 1:size(pf_poi,2)
    plot(omegalin,pf_poi(:,i),'--','LineWidth',1); hold on
end
xlim([0 max(omegalin)])
if isempty(a.fmotion_ylim) == 0;
    ylim(a.fmotion_ylim(leftright,:))
end
xlabel('Frequency [rad/s]','InterPreter','LaTex','Fontsize',15)
ylabel('Fluid pressure (N/m$^2$)','InterPreter','LaTex','Fontsize',15)
if leftright == 1; title('Fluid left side','InterPreter','LaTex','Fontsize',15); end
if leftright == 2; title('Fluid right side','InterPreter','LaTex','Fontsize',15); end
set(gca,'TicklabelInterPreter','LaTex','Fontsize',14)
grid on
legendInfo{1} = 'Fluid maximum'; for i = 1:size(pf_poi,2); legendInfo{i+1} = ['Point ' num2str(i) ': (' num2str(a.poi(i,1)) ',' num2str(a.poi(i,2)) ')']; end
ll=legend(legendInfo);
set(ll,'InterPreter','LaTex','Fontsize',12)
    if a.saveplots ==1;
            specificfolder = sprintf('\fluidresponse\');
            figurename = sprintf('%d_%d',round(min(omegalin)),round(max(omegalin)));
            fullfigurename = fullfile(outputfigures, specificfolder, figurename);
            export_fig(fullfigurename,'-eps','-png')
    end

% Function end
end
