function plot_H(H,f,cc,a)
if a.H(1) == 1;

if a.H(2) == 0
    plotmaxomega = max(f.omegavec);
else
    plotmaxomega = a.H(2);
end

for i = 1:size(a.poi,1)
    %------------------------------------------------------------
    ff=figure;
    subplot(3,1,1)
    if a.H(3) == 0;
        if isfield(f,'n_shortened') == 1;
           plot(f.omegavec,abs(f.Y0(1:f.n_shortened)),'k');
        else
           plot(f.omegavec,abs(f.Y0),'k');
        end
    else
    semilogy(f.omegavec,abs(f.Y0(1:f.n_shortened)),'k');
    end
    grid on
    xlim([0 plotmaxomega]);
    set(gca,'Fontsize',12);
    ylabel('Force spectrum','Interpreter','Latex','Fontsize',16);
     set(gca,'YTick',[]);
    if a.title == 1; title(['Spectral force and response at (x,z) = ' num2str(a.poi(i,1)) ',' num2str(a.poi(i,2))  'm'],'Interpreter','Latex','Fontsize',16); end
    %------------------------------------------------------------
    subplot(3,1,2)
    Hplot(:) = H(a.poi(i,1)/cc.dx+1,a.poi(i,2)/cc.dz+1,1:f.n_shortened);
    if a.H(3) == 0;
    plot(f.omegavec,real(Hplot),'k-.','LineWidth',0.5); hold on
    plot(f.omegavec,imag(Hplot),'k--','LineWidth',0.5); hold on
    plot(f.omegavec,abs(Hplot),'k');
    else
    semilogy(f.omegavec,real(Hplot),'k-.','LineWidth',0.5); hold on
    semilogy(f.omegavec,imag(Hplot),'k--','LineWidth',0.5); hold on
    semilogy(f.omegavec,abs(Hplot),'k');
    end
    xlim([0 plotmaxomega]);
    ll=legend('Real','Imaginary','Absolute');
    set(ll,'Interpreter','Latex');
    grid on;
    set(gca,'Fontsize',12);
    ylabel('Transfer function','Interpreter','Latex','Fontsize',16);
     set(gca,'YTick',[]);
    set(gca,'Ticklabelinterpreter','Latex','Fontsize',14)
    %------------------------------------------------------------
    subplot(3,1,3)
    if a.H(3) == 0;
    plot(f.omegavec,abs(Hplot(1:f.n_shortened).*f.Y0(1:f.n_shortened)),'k');
    else
    semilogy(f.omegavec,abs(Hplot(1:f.n_shortened).*f.Y0(1:f.n_shortened)),'k');
    end
    xlim([0 plotmaxomega]);
    set(gca,'Fontsize',12);
    xlabel('Frequency [rad/s]','Interpreter','Latex','Fontsize',16);
    ylabel('Response','Interpreter','Latex','Fontsize',16);
     set(gca,'YTick',[]);
    grid on
    %------------------------------------------------------------
    set(gcf, 'units','normalized','outerposition',[0 0 1 1],'color','white');
    %------------------------------------------------------------
    if a.saveplots ==1;
            specificfolder = 'spectral';
            fullfoldername = fullfile(a.plotfolder,specificfolder);
            if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
            figurename = sprintf('spectralforceandresponse_x%d_z%d',a.poi(i,1)*10,a.poi(i,2)*10);
            fullfigurename = fullfile(a.plotfolder, specificfolder, figurename);
            export_fig(fullfigurename,'-eps','-png')
    end
    %------------------------------------------------------------
end

end
