function f = forcetime_signaltransform(f,maxomeg)
f.tin = f.t;

% Determine first and last force value that is not zero
[~,i_start] = find(abs(f.amp)>0,1,'first');
[~,i_end] = find(abs(f.amp)>0,1,'last');

% Set t(1) = 0
f.t = f.t-f.t(1);

% Determine time input signal parameters
tend = f.t(end);
dt = f.t(2)-f.t(1);
nt = length(f.t);

% Add start time and end time with amp=0
f.ampn(1:round(f.addstart/dt)) = 0;
f.ampn(round(f.addstart/dt)+1:round(f.addstart/dt)+round(tend/dt)+1) = f.amp;
f.ampn(round(f.addstart/dt)+round(tend/dt)+2:round(f.addstart/dt)+round(tend/dt)+round(f.addend/dt)+1) = 0;

f.t = 0:dt:((f.addstart+tend+f.addend))+dt;
f.amp = f.ampn;

% Determine new time signal parameters
tend = f.t(end);
dt = f.t(2)-f.t(1);
nt = length(f.t);

% Even sized time length
if mod(length(f.t),2) == 1
    f.n = nt-1;
else
    f.n = nt;
end
f.t = f.t(1:f.n);
f.amp = f.amp(1:f.n);

% Fourier transform
fs = 1/dt;  % Sample frequency (Hz) = number of points / second
fnyq = fs/2; % Nyquist frequency (Hz)
freq = (0:f.n-1)*(fs/f.n);

% FFT
f.Y = fft(f.amp);
f.omegafft = freq*2*pi;

% Shortened FFT results
f.Y0 = f.Y(1:f.n/2+1);
f.omegavec = freq(1:f.n/2+1)*2*pi;
f.n_restore = length(f.omegavec);

if nargin == 2
    if maxomeg>0;
    [~,f.n_shortened] = find(f.omegavec >= maxomeg,1,'first');
    f.omegavec = f.omegavec(1:f.n_shortened);
    else f.n_shortened = f.n;
    end
else f.n_shortened = f.n;
end

f.tshift = f.tin(1)-f.t(1)-f.addstart;