function thinplatemodes(v,cc)

% Check if data already exists
if exist(['.\Modes\omegan_size_' num2str(round(v.Lx*1000)) 'x' num2str(round(v.Lz*1000)) '_rho_' num2str(round(v.rhos)) '_EI_' num2str(round(real(v.EI))) '_eta_' num2str(v.eta) '.mat'],'file') == 2
    load(['.\Modes\omegan_size_' num2str(round(v.Lx*1000)) 'x' num2str(round(v.Lz*1000)) '_rho_' num2str(round(v.rhos)) '_EI_' num2str(round(real(v.EI))) '_eta_' num2str(v.eta) '.mat'])
    if size(omegan,1)>=cc.smodes && size(omegan,2) >= cc.smodes
    fprintf('Loading existing plate modes...\n')
    return
    else
    knownmodes = length(omegan);
    fprintf('Calculating additional plate modes...\n')   
    end
else
    fprintf('Calculating plate modes...\n')
    knownmodes = 0;
end

% Variables
global p
p.nu = v.nu;
p.Lx = v.Lx;
p.Lz = v.Lz;
p.rhos = v.rhos;
p.EI = v.EI;
p.eta = v.eta;
p.D = p.EI/(1-p.nu^2);
find_k_modes = cc.smodes;
find_m_modes = cc.smodes;

if knownmodes > 0
   omegaf = omegan;
   clear omegan
end

for k = 1:find_k_modes
    p.k = k;
    p.betak = p.k*pi/p.Lx;

    % Set trial value of omega
    if p.k == 1
        omega = sqrt(4000+4000*p.eta*1j);  % start value for finding omega's
        dO = sqrt(60+60*p.eta*1j); dOorig = dO;
        if p.k <= knownmodes
            m = knownmodes;
            npeaksfprev = knownmodes;
            omega = omegaf(p.k,m)+ dO;  % start value for finding omega's
        else
            m = 0;
            npeaksfprev = 0;
        end
    else
        dO = sqrt(60+60*p.eta*1j); dOorig = dO;
        if p.k <= knownmodes
            m = knownmodes;
            npeaksfprev = knownmodes;
            omega = omegaf(p.k,m)+ dO;  % start value for finding omega's
        else
            m = 0;
            npeaksfprev = 0;
            omega = omegaf(p.k-1,1)+dO;  % start value for finding omega's
        end
    end
    
    firstguess = 1;
    option = bvpset('RelTol',(10^-6),'Abstol',(10^-6),'NMax',10000);

    while m < find_m_modes
        fprintf('Horizontal mode: %d (/%d)\n',p.k,find_k_modes)

        p.betam = (((m)+0.25)*pi)/p.Lz; %sqrt(omega/sqrt(p.EI/p.rhos));
        fprintf('Trying omega: %f + %f i\n',real(omega),imag(omega))
        
        solinit = bvpinit(linspace(0,p.Lz,100),@mat4init,omega);
        sol = bvp4c(@plateode,@platebc,solinit,option);
        fprintf('Finding omega %f + %f i\n',real(sol.parameters),imag(sol.parameters))

        xint = linspace(0,p.Lz,1000);
        Sxint = deval(sol,xint); zdefl(:) = Sxint(1,:);  
        
        % Plot found mode shape
%         figure
%         plot(xint,real(zdefl)); hold on
%         plot(xint,imag(zdefl));
%         title(sprintf('omega = %f',real(sol.parameters)));
%         drawnow
%         pause(1);
        
        % Determine number of peaks = mode number
        pksmin = findpeaks(real(zdefl));
        pksmax = findpeaks(-real(zdefl));
        npeaksf = length(pksmin) + length(pksmax) + 1;
        fprintf('Previous peaks found: %d (/%d) \n',npeaksfprev,find_m_modes)

        if npeaksf == npeaksfprev + 1 && sol.parameters > 0
            m = m + 1;
            omegaf(p.k,m) = sol.parameters;
            save(['.\Modes\Wkm_size_' num2str(round(v.Lx*1000)) 'x' num2str(round(v.Lz*1000)) '_rho_' num2str(round(v.rhos)) '_EI_' num2str(round(real(v.EI))) '_eta_' num2str(v.eta) '_modes_' num2str(k) 'x' num2str(m) '.mat'],'sol')
            
            % Set next dO step for iteration 
            if m>1
                dOorig = (omegaf(p.k,m) - omegaf(p.k,m-1))/3;
            elseif m == 1 && p.k > 1
                dOorig = (omegaf(p.k-1,m+1) - omegaf(p.k-1,m))/3;
            elseif m == 1 && p.k == 1
                dOorig = omegaf(p.k,m)/5;
            end
            dO = dOorig; 
            
            % Set next omega guess for iteration
            %if p.k > 1
            %    omega = omegaf(p.k-1,m)+ dO;
            %else   
                omega = sol.parameters + dO;
            %end
            npeaksfprev = npeaksf;

        elseif npeaksf == 0 && m == 0 && firstguess == 1 && sol.parameters > 0
            firstguess = 0;
            if p.k > 1
                omega = omegaf(p.k-1,1)+ dO;
            else   
                omega = sol.parameters;
            end
        elseif npeaksf == npeaksfprev + 1 && sol.parameters <= 0;
            omega = omega + dO;
        elseif npeaksf == npeaksfprev
            omega = omega + dO;
        elseif npeaksf > npeaksfprev + 1
            %if m > 0; omega = omegaf(p.k,m); end
            if m >= 0; omega = omega/2; end
            dO = dO/2;
        elseif npeaksf < npeaksfprev
            omega = omega + dO;
        end
        fprintf('Peaks found now: %d\n',npeaksf)
    end
end

omegan = omegaf;
save(['.\Modes\omegan_size_' num2str(round(v.Lx*1000)) 'x' num2str(round(v.Lz*1000)) '_rho_' num2str(round(v.rhos)) '_EI_' num2str(round(real(v.EI))) '_eta_' num2str(v.eta) '.mat'],'omegan')

disp('Finished')
%------------------------------------------------------------
function dydx = plateode(x,z,omega)
% Variables
global p
dydx = [  z(2)
          z(3)
          z(4)
          2*p.betak^2*z(3)+(p.rhos*omega^2)/p.D*z(1)-p.betak^4*z(1)];
%------------------------------------------------------------
function res = platebc(ya,yb,omega)
global p
res = [  ya(1); ya(3);
         yb(3)-p.nu*p.betak^2; yb(4)-(2-p.nu)*p.betak^2*yb(2); abs(yb(1)-1)];
%------------------------------------------------------------
function zinit = mat4init(z)
global p
betam = p.betam;
Lz = p.Lz;
plot(((sinh(betam*z)+sinh(betam*Lz)/sin(betam*Lz)*sin(betam*z))/(2*sinh(betam*Lz))))
zinit = [((sinh(betam*z)+sinh(betam*Lz)/sin(betam*Lz)*sin(betam*z))/(2*sinh(betam*Lz)))
         ((cosh(betam*z)+sinh(betam*Lz)/sin(betam*Lz)*cos(betam*z))/(2*sinh(betam*Lz)))
         ((sinh(betam*z)-sinh(betam*Lz)/sin(betam*Lz)*sin(betam*z))/(2*sinh(betam*Lz)))
         ((cosh(betam*z)-sinh(betam*Lz)/sin(betam*Lz)*cos(betam*z))/(2*sinh(betam*Lz)))];
%------------------------------------------------------------
