function [out,v,a,f] = model_main(v,cc,a,f,modes)

%% Start values
startt=tic;
[a,v] = model_defaultoutput(a,v); % default all values that have not been passed in the set-file
model_checktoolboxes({'MATLAB'; 'Optimization_Toolbox'; 'PDE_Toolbox'; 'Statistics_Toolbox'; 'Symbolic_Toolbox'})

%% Parameters and settings
% Coordinate vectors structure
v.x = 0:cc.dx:v.Lx;
v.z = 0:cc.dz:v.Lz;
v.f1.x = 0:cc.f1.dx:v.f1.Lx; v.f2.x = 0:cc.f2.dx:v.f2.Lx; v.f3.x = 0:cc.f3.dx:v.f3.Lx;
v.f1.H = v.f1.h; v.f2.H = v.f2.h; v.f3.H = v.f3.h;
v.f1.z = linspace(0,v.f1.H,round(v.f1.H/cc.f1.dz+1)); v.f2.z = linspace(0,v.f2.H,round(v.f2.H/cc.f2.dz+1)); v.f3.z = linspace(0,v.f3.H,round(v.f3.H/cc.f3.dz+1));
v.f1.DX = (v.Lx - v.f1.Lx)/2; v.f2.DX = (v.f2.Lx - v.f1.Lx)/2; v.f3.DX = (v.Lx - v.f3.Lx)/2; % Sluice and gate edge offset, domain I and domain II edge offset
v.zQ = linspace(0,v.f1.h-v.zbot,round((v.f1.h-v.zbot)/cc.f1.dz+1));
v.zT = linspace(0,v.f3.h-v.zbot,round((v.f3.h-v.zbot)/cc.f3.dz+1));
v.zR = linspace(0,v.f1.h,round(v.f1.h/cc.f1.dz+1));

%% Preallocation final matrix
M = zeros(cc.f1.modes*2,cc.f1.modes*2);
AK_1_1 = zeros(cc.smodes,cc.smodes);
AK_1_2 = zeros(cc.smodes,cc.smodes);
AK_2 = zeros(cc.f1.modes,cc.smodes);
BPmin_1 = zeros(cc.smodes,cc.f1.modes);
BPplus_1 = zeros(cc.smodes,cc.f1.modes);
BPmin_2 = zeros(cc.f1.modes,cc.f1.modes);
BPplus_2 = zeros(cc.f1.modes,cc.f1.modes);
BPmin_3_1 = zeros(cc.f1.modes,cc.f1.modes);
BPmin_3_2 = zeros(cc.f1.modes,cc.f1.modes);
BPplus_3_1 = zeros(cc.f1.modes,cc.f1.modes);
BPplus_3_2 = zeros(cc.f1.modes,cc.f1.modes);
Fln = zeros(1,cc.smodes);

%% Start omega independent part
% -----------------------------
%% Load all modes
Wxz = modes.Wxz;
f1 = model_fluidmodes_closed(v.f1,cc.f1);
f2 = model_fluidmodes_free(v.f2,cc.f2);
if v.f3.h > 0; f3 = model_fluidmodes_free(v.f3,cc.f3); end

%% Integration constant structural modes
GW = ones(1,cc.smodes); % Input modes are already mass-normalized
omegan = modes.omegan;

%% Modal force Fl
fprintf('Determining modal forces...\n')

% Modal force 
if a.forceintervals == 0
    if a.F==1; plot_force(v.x,v.z,f,a); end
    for ln = 1:cc.smodes
       Fln(ln) = trapz(v.x,trapz(v.z,f.F(:,:).*Wxz(:,:,ln),2));
    end
elseif a.forceintervals == 1
    for ii = 1:f.n_ivx
        for jj = 1:f.n_ivz
            ii_ivx = f.ii_ivx;
            ii_ivz = f.ii_ivz;
            f.F = f.interval(ii,jj).F;
            for ln = 1:cc.smodes
               Fln(ln) = trapz(v.x(ii_ivx(ii):ii_ivx(ii+1)),trapz(v.z(ii_ivz(jj):ii_ivz(jj+1)),f.F(ii_ivx(ii):ii_ivx(ii+1),ii_ivz(jj):ii_ivz(jj+1)).*Wxz(ii_ivx(ii):ii_ivx(ii+1),ii_ivz(jj):ii_ivz(jj+1),ln),2));
            end
            Fln_iv(:,ii,jj) = Fln(:);
        end
    end
    %     Wkones = ones(size(Wkm));
    %     Fln_check = trapz(v.x,trapz(v.z(ii_iv(ivn):ii_iv(ivn+1)),f.F(:,ii_iv(ivn):ii_iv(ivn+1)).*Wkones(:,ii_iv(ivn):ii_iv(ivn+1),ln),2));
end

%% Surface integrals Q,T,R

% Integral Q
for km = 1:cc.smodes
    for p1 = 1:cc.f1.fxmodes
        for p2 = 1:cc.f1.fzmodes
        p = (p1-1)*cc.f1.fzmodes+p2;
        Q(p,km) = trapz(v.zQ,trapz(v.f1.x,(Wxz(round(v.f1.DX/cc.dx)+1:round((v.Lx-v.f1.DX)/cc.f1.dx)+1,1:round(((v.f1.h-v.zbot)/cc.f1.dz+1)),km).*f1.P(round(v.f1.DX/cc.dx)+1:round((v.Lx-v.f1.DX)/cc.f1.dx)+1,round(v.zbot/cc.f3.dz+1):round(v.f1.h/cc.f1.dz+1),p))));
        end
    end
end

% Integral T
if v.f3.h > 0
    for km = 1:cc.smodes
        for p1 = 1:cc.f3.fxmodes
            for p2 = 1:cc.f3.fzmodes
            p = (p1-1)*cc.f3.fzmodes+p2;
            T(p,km) = trapz(v.zT,trapz(v.f3.x,(Wxz(round(v.f3.DX/cc.dx)+1:round((v.Lx-v.f3.DX)/cc.f3.dx)+1,1:round(((v.f3.h-v.zbot)/cc.f3.dz+1)),km).*f3.P(round(v.f3.DX/cc.dx)+1:round((v.Lx-v.f3.DX)/cc.f3.dx)+1,round(v.zbot/cc.f3.dz+1):round(v.f3.h/cc.f3.dz+1),p))));
            end
        end
    end
end

% Integral R = P1*P2
% Integral R in x-direction
for r1 = 1:cc.f2.fxmodes
    for p1 = 1:cc.f1.fxmodes
    R_intxL(r1,p1) = trapz(v.f1.x,f2.X(round(v.f2.DX/cc.f2.dx)+1:round((v.f2.Lx-v.f2.DX)/cc.f2.dx+1),r1).*f1.X(:,p1));
    end
end

% Integral R in z-direction
for r2 = 1:cc.f2.fzmodes
    for p2 = 1:cc.f1.fzmodes
    R_intzL(r2,p2) = trapz(v.zR,f2.Z(1:round(v.f1.h/cc.f1.dz+1),r2).*f1.Z(1:round(v.f1.h/cc.f1.dz+1),p2));
    end
end

% Integral R combined
for r1 = 1:cc.f2.fxmodes
    for r2 = 1:cc.f2.fzmodes
        r = (r1-1)*cc.f2.fzmodes+r2;
        for p1 = 1:cc.f1.fxmodes
            for p2 = 1:cc.f1.fzmodes
                p = (p1-1)*cc.f1.fzmodes+p2;
                R(p,r) = R_intxL(r1,p1)*R_intzL(r2,p2);
            end
        end
    end
end

%% START OMEGA DEPENDENT PART
fprintf('Starting calculation of the gate fluid system for %d frequencies...\n',length(f.omegavec))
for o = 1:length(f.omegavec)
tstartloop=tic;
Omega = f.omegavec(o);
if Omega == 0; Omega = f.omegavec(2)/1000; end

%% kyI and kyII
% Compressible or incompressible fluid
if a.compressible == 1 || o == 1
v.kf = Omega/v.cp;
    
% FLUID I: Separation constant in y-direction
for p1 = 1:cc.f1.fxmodes
    for p2 = 1:cc.f1.fzmodes
        p = (p1-1)*cc.f1.fzmodes+p2;
        if (v.kf^2 - f1.kx(p1)^2 - f1.kz(p2)^2) < 0
            f1.ky(p) = -sqrt(v.kf^2 - f1.kx(p1)^2 - f1.kz(p2)^2);
        else
            f1.ky(p) =  sqrt(v.kf^2 - f1.kx(p1)^2 - f1.kz(p2)^2);
        end
        if real(f1.ky(p)) == 0; f1.ky(p)= f1.ky(p) + 10^-20; end
        if imag(f1.ky(p)) == 0; f1.ky(p)= f1.ky(p) + (10^-20)*1j; end
    end
end

% FLUID II: Separation constant in y-direction
for r1 = 1:cc.f2.fxmodes
    for r2 = 1:cc.f2.fzmodes
        r = (r1-1)*cc.f2.fzmodes+r2;
        if (v.kf^2 - f2.kx(r1)^2 - f2.kz(r2)^2) < 0
            f2.ky(r) = -sqrt(v.kf^2 - f2.kx(r1)^2 - f2.kz(r2)^2);
        else
            f2.ky(r) =  sqrt(v.kf^2 - f2.kx(r1)^2 - f2.kz(r2)^2);
        end
        if real(f2.ky(r)) == 0; f2.ky(r) = f2.ky(r) + 10^-20; end
        if imag(f2.ky(r)) == 0; f2.ky(r) = f2.ky(r) + (10^-20)*1j; end
    end
end
end

% FLUID III: Separation constant in y-direction
if v.f3.h>0
    for t1 = 1:cc.f3.fxmodes
        for t2 = 1:cc.f3.fzmodes
            t = (t1-1)*cc.f3.fzmodes+t2;
            if (v.kf^2 - f3.kx(t1)^2 - f3.kz(t2)^2) < 0
                f3.ky(t) = -sqrt(v.kf^2 - f3.kx(t1)^2 - f3.kz(t2)^2);
            else
                f3.ky(t) =  sqrt(v.kf^2 - f3.kx(t1)^2 - f3.kz(t2)^2);
            end
            if real(f3.ky(t)) == 0; f3.ky(t)= f3.ky(t) + 10^-20; end
            if imag(f3.ky(t)) == 0; f3.ky(t)= f3.ky(t) + (10^-20)*1j; end
        end
    end
end

%% Filling equation 1
Ik = (omegan.^2-Omega^2).*GW;
Ck = v.cdamp*1j*Omega*GW;

AK_1_1 = diag(Ik)+diag(Ck);
if v.f3.h>0
    for km = 1:cc.smodes
        for ln = 1:cc.smodes
            AK_1_2(ln,km) = v.f3.rhof*1j*Omega^2*sum(T(:,km).*T(:,ln)./(f3.ky.*f3.DZ).');
        end
    end
else; AK_1_2 = zeros(cc.smodes,cc.smodes);
end
AK_1 = AK_1_1+AK_1_2;

for ln = 1:cc.smodes
    for p = 1:cc.f1.modes
        BPmin_1(ln,p) = -v.f1.rhof*1j*Omega*Q(p,ln)*exp(-1j*f1.ky(p)*v.f1.Ly);
        BPplus_1(ln,p) = -v.f1.rhof*1j*Omega*Q(p,ln);
    end
end

%% Filling equation 2
BPmin_2  = diag(+f1.ky.*f1.DZ.*exp(-1j*f1.ky*v.f1.Ly));
BPplus_2  = diag(-f1.ky.*f1.DZ);

for km = 1:cc.smodes
    for q = 1:cc.f1.modes
        AK_2(q,km) = -Omega*Q(q,km); % Not clear why - and not +
    end
end

%% Filling equation 3
BPmin_3_1  = (diag(+v.f1.rhof/v.f2.rhof*f1.DZ));
BPplus_3_1 = (diag(+v.f1.rhof/v.f2.rhof*exp(-1j*f1.ky*v.f1.Ly).*f1.DZ));

for p = 1:cc.f1.modes
    for q = 1:cc.f1.modes
        BPmin_3_2(q,p) = +f1.ky(p)*sum((R(p,:).*R(q,:))./(f2.ky.*f2.DZ));
    end
end
for p = 1:cc.f1.modes
    for q = 1:cc.f1.modes
        BPplus_3_2(q,p) = -f1.ky(p)*exp(-1j*f1.ky(p)*v.f1.Ly)*sum((R(p,:).*R(q,:))./(f2.ky.*f2.DZ));
    end
end

BPmin_3 = BPmin_3_1+BPmin_3_2;
BPplus_3 = BPplus_3_1+BPplus_3_2;
AK_3 = zeros(cc.f1.modes,cc.smodes);

%% Constructing total matrix and determination of modal coefficients
M = [[AK_1 BPplus_1 BPmin_1]; [AK_2 BPplus_2 BPmin_2]; [AK_3 BPplus_3 BPmin_3]];
if a.forceintervals == 0
    Fm = [Fln zeros(1,cc.f1.modes) zeros(1,cc.f1.modes)];
    MC = Fm/M.';
    Aln = MC(1:cc.smodes);
    Bplus = MC(cc.smodes+1:cc.smodes+cc.f1.modes);
    Bmin = MC(cc.smodes+cc.f1.modes+1:cc.smodes+2*cc.f1.modes);
elseif a.forceintervals == 1
    if a.nwaves == 0
        for ii = 1:f.n_ivx
            for jj = 1:f.n_ivz
                Fln_vec(1,:) = Fln_iv(:,ii,jj);
                Fm = [Fln_vec zeros(1,cc.f1.modes) zeros(1,cc.f1.modes)];
                MC(:,ii,jj) = Fm/M.';
                Aln_iv_ifft(:,ii,jj) = MC(1:cc.smodes,ii,jj)*f.interval(ii,jj).Y0(o);
                Bplus_iv_ifft(:,ii,jj) = MC(cc.smodes+1:cc.smodes+cc.f1.modes,ii,jj)*f.interval(ii,jj).Y0(o);
                Bmin_iv_ifft(:,ii,jj) = MC(cc.smodes+cc.f1.modes+1:cc.smodes+2*cc.f1.modes,ii,jj)*f.interval(ii,jj).Y0(o);
            end
        end
        Aln(1,:) = sum(Aln_iv_ifft,[2 3]);
        Bplus(1,:) = sum(Bplus_iv_ifft,[2 3]);
        Bmin(1,:) = sum(Bmin_iv_ifft,[2 3]);
    else
       	for ii = 1:f.n_ivx
            for jj = 1:f.n_ivz
            Fln_vec(1,:) = Fln_iv(:,ii,jj);
            Fm = [Fln_vec zeros(1,cc.f1.modes) zeros(1,cc.f1.modes)];
            MC = Fm/M.';
            interval(ii,jj).Aln_RAO(:,o) = MC(1:cc.smodes);
            interval(ii,jj).Bplus_RAO(:,o) = MC(cc.smodes+1:cc.smodes+cc.f1.modes);
            interval(ii,jj).Bplus_RAO(:,o) = MC(cc.smodes+cc.f1.modes+1:cc.smodes+2*cc.f1.modes);
            end
        end
    end
end

if a.forceintervals == 0 || a.nwaves == 0
    for r = 1:cc.f2.modes
        Cplus(r) = 1/(1j*f2.ky(r)*f2.DZ(r))*sum((-Bmin.*1j.*f1.ky+Bplus.*1j.*f1.ky.*exp(-1j*f1.ky*v.f1.Ly)).*R(:,r).'); 
    end
    if v.f3.h>0
        for t = 1:cc.f3.modes
            Dplus(t) = Omega/(f3.ky(t)*f3.DZ(t))*sum(Aln.*T(t,:));
        end
    end
end

% Check if solution succeeded
NrNaN = sum(isnan(MC(1,:)));
if NrNaN > 0
    error('Model solution (Aln) contains NaN. Frequency: %f (%i)',Omega,o);
end

if a.nwaves == 0
    Akm = Aln;
    Akm_H(:,o) = Aln; % saved frequency response in terms of modal coefficients
    if a.fft == 0
        for km = 1:cc.smodes
            Wmodes(:,:,km) = Akm(km)*Wxz(:,:,km);
        end
        w = sum(Wmodes,3);
        w_abs = abs(w); % absolute value of summed quantified mode contributions;
    end
end

%% Plate deflection per frequency
% Maximum plate's deflection
if any(a.pmotion) == 1
    max_w_amp(o) = max(max(w_abs)); % plate's maximum deflection on any location, different for each omega
    for i = 1:size(a.poi,1)
    w_poi(o,i) = w_abs(round(a.poi(i,1)/cc.dx+1),round(a.poi(i,2)/cc.dz+1)); % plate's deflection at poi's
    end
end

%% Time left
tloop(o)=toc(tstartloop);
if a.freqmovie == 1
tmovdiff= tloop(o)-tmovie;
tmov = [tmovie tmovdiff a.tcomp1 a.tcomp2 a.tcomp3 a.tplot a.tsave];
disp(tmov)
end
if o == 13
    timeremainminprev = timeremainmin;
    timeremainsev.cprev = timeremainsec;
end
if o>13
    timeremainminprev = min(timeremainmin,timeremainminprev);
    timeremainsev.cprev = min(timeremainsec,timeremainsev.cprev);
end
if o>11
    tloopa = sum(tloop(end-10:end))/11;
    timeremainmin = round(tloopa*(length(f.omegavec)-o)/60);
    timeremainsec = round(tloopa*(length(f.omegavec)-o));
end
if o>12
    if or(timeremainmin < timeremainminprev,o==13) || timeremainsec < 181
        if timeremainsec > 180
            clc;fprintf('Time past: %i [min] \n',round(sum(tloop)/60))
            fprintf('Estimated time remaining: %d [min]\n',timeremainmin)
        else
            if timeremainsec < timeremainsev.cprev
                clc;fprintf('Time past: %i [min] \n',round(sum(tloop)/60))
                fprintf('Estimated time remaining: %d:%02d [min]\n', floor(timeremainsec/60),rem(timeremainsec,60))
            end
        end
    end
end
   
end % End omega loop    
fprintf('Calculation finished\n')

%% Frequency analysis after
% Find natural frequencies by peaks.
if a.pks == 1; omegapks = omegapeaks(f.omegavec,max_w_amp); end

% Plotting plate's motion over frequency range (max and poi's)
if isempty(a.poi) == 1; w_poi = []; end
if (any(a.pmotion == 1) == 1); plot_pmotion(f.omegavec,max_w_amp,w_poi,a); end

% Plotting fluid's motion over frequency range (max and poi's)
if isempty(a.poi) == 1; pfL_poi = []; pfR_poi = []; end
if a.fmotion(1) == 1; leftright = 1; plot_fmotion(f.omegavec,max_pfL_amp,pfL_poi,leftright,a); end
if a.fmotion(2) == 1; leftright = 2; plot_fmotion(f.omegavec,max_pfR_amp,pfR_poi,leftright,a); end

%% Passing all requested parameters to out. structure and .mat file
calc_time = toc(startt); a.outputpar = [a.outputpar, {'calc_time'}];
for i = 1:length(a.outputpar); out.(genvarname(a.outputpar{i})) = eval(genvarname(a.outputpar{i})); end

% Saving requested variables
if isempty(a.outputpar) == 0; save(['.\results\' a.casecode '\results.mat'],a.outputpar{:}); end
if a.saveresults == 1; save(['.\results\' a.casecode '\casepars.mat'],'a','f','cc','v','out'); end

%% Subfunctions
function [omegapks] = omegapeaks(omegalin,max_w_amp)
[~,pksmax] = findpeaks(max_w_amp);
if length(pksmax)>=1
    for i = 1:length(pksmax)
    omegapks(i) = omegalin(pksmax(i));
    end
else
    omegapks = 'No peaks founds';
end