function [fshape]= model_fluidmodes_closed(vf,ccf)

%% Determining fshapes
% X-direction, constant and fshape
for p = 1:ccf.fxmodes
    fshape.kx(p) = (p-1)*pi/vf.Lx; % Separation constant
    for i = 1:length(vf.x)
        fshape.X(i,p) = cos(fshape.kx(p)*vf.x(i));
    end
end
       
% Z-direction, without surface waves, constant and fshape
for r = 1:ccf.fzmodes
    fshape.kz(r) = (r-1)*pi/vf.h; % Separation constant
    for i = 1:length(vf.z)
       fshape.Z(i,r) = cos(fshape.kz(r)*vf.z(i));
    end
    % Normalising z-fshapes
    fshape.Z(:,r) = fshape.Z(:,r)./max(abs(fshape.Z(:,r)));
end

% Combined 2D fshape
for p = 1:ccf.fxmodes
    for r = 1:ccf.fzmodes
        pr = (p-1)*ccf.fzmodes+r;
        fshape.P(:,:,pr) = fshape.X(:,p)*transpose(fshape.Z(:,r));
    end
end

% Integration constant fluid modes
for p = 1:ccf.fxmodes
    for r = 1:ccf.fzmodes
        pr = (p-1)*ccf.fzmodes+r;
        fshape.DZ(pr) = trapz(vf.x,fshape.X(:,p).^2)*trapz(vf.z,fshape.Z(:,r).^2);
    end
end

%% Plotting modes
% if a.fmodes == 1; plot_fmodes1D(v.xf,v.zf,fshape.P,ccf.fzmodes,Omega,a); end
% if a.fmodes == 2; plot_fmodes(vf.xgrid,vf.zgrid,fshape.P,ccf.fmodes,Omega,a); end
