function [f] = data_3D_makeintervals(v,cc,f)

%% Parameters  
iv_x = f.iv_x;
iv_z = f.iv_z;

ii_ivz = round(iv_z/cc.dz+1,0); % Indexes of interval boundaries
f.n_ivz = length(ii_ivz)-1;
ii_ivx = round(iv_x/cc.dx+1,0); % Indexes of interval boundaries
f.n_ivx = length(ii_ivx)-1;

p = f.p;
z = 0:cc.dz:v.f1.h; 

% Factor to change amplitudes of the load over the width based on the skewness factor 
skewness_factor_x = (1+f.skewness_width/2-f.skewness_width*iv_x/(v.Lx));

%% Making intervals
% Determining integrals in z-direction
for jj=1:length(ii_ivz)-1  % loop over intervals
    integral_iv(:,jj) = trapz(z(ii_ivz(jj):ii_ivz(jj+1)),p(:,ii_ivz(jj):ii_ivz(jj+1)),2);
end
integral_total = trapz(z,p(:,:),2).';

% Find maximum of total
if isfield(f,'pmean') == 1
    [~,i_m] = max(f.pmean);
else
    [~,i_m] = max(integral_total);
end

% Creating new wave signal for waveparts
for ii = 1:f.n_ivx
    for jj = 1:f.n_ivz
        f.interval(ii,jj).amp = zeros(1,size(p,1));
    end
end
for i = 1:size(p,1) % loop over time steps
    for ii = 1:length(ii_ivx)-1
        for jj=1:length(ii_ivz)-1  % loop over intervals
            f.interval(ii,jj).amp(i) = ((skewness_factor_x(ii+1)+skewness_factor_x(ii))/2)*integral_iv(i,jj)/(z(ii_ivz(jj+1))-z(ii_ivz(jj))); % average pressure at time step
        end
    end
end

% Creating force vector for frequency analysis
f.static.F = zeros(length(0:cc.dx:v.Lx),length(0:cc.dz:v.f1.h),1,1);
for ii = 1:length(ii_ivx)-1
    for jj = 1:f.n_ivz
    f.interval(ii,jj).F = zeros(length(0:cc.dx:v.Lx),length(0:cc.dz:v.f1.h),1,1);
    end
end
for ii = 1:length(ii_ivx)-1
    for jj=1:length(ii_ivz)-1  % loop over intervals
        f.interval(ii,jj).F(ii_ivx(ii):ii_ivx(ii+1),ii_ivz(jj):ii_ivz(jj+1),1,1) = 1;
        f.static.F(ii_ivx(ii):ii_ivx(ii+1),ii_ivz(jj):ii_ivz(jj+1),1,1) = f.interval(ii,jj).amp(i_m);
    end
end

%% Plotting results
% figure
% contourf(f.interval(2,2).F(:,:,1,1).')
% 
% figure
% contourf(f.static.F.')
% 
% figure
% for i = 1:size(f.interval,1)
%     for j = 1:size(f.interval,2)
%         plot(f.t,f.interval(i,j).amp); hold on
%     end
% end

%% Construct force parameters for analysis
f.n_ivx = length(ii_ivx)-1;
f.n_ivz = length(ii_ivz)-1;
f.ii_ivx = ii_ivx;
f.ii_ivz = ii_ivz;
f.totalforce = integral_total;