function plot_pshape_contr(a,Akm,options)

% --- Set unallocated options to default ---
if isfield(options,'title') == 0; if isfield(options,'titlename') == 1; options.title = 1; else options.title = 0; end; end
if isfield(options,'dataname') == 0; options.dataname = 'Plateshape_contr'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = ''; end 
if isfield(options,'nmodes_contr') == 0; options.nmodes_contr = 1000; end
if isfield(options,'relative') == 0; options.relative = 'yes'; end

% ---Check if requested modes to be plotted is below the number used in the calculations ---
if options.nmodes_contr > length(Akm(:,1)) options.nmodes_contr = length(Akm(1,:)); end


% Relative contributions of Akm
[KK,MM] = meshgrid(1:1:options.nmodes_contr,1:1:options.nmodes_contr);
Akmp = abs(Akm(1:options.nmodes_contr));
Akmtot = sum(sum(Akmp));
ff=figure;
if strcmp(options.relative,'yes') == 1
    h=bar(abs(Akmp)/Akmtot*100);
    ylabel('Relative contribution [$\%$]','InterPreter','LaTex','Fontsize',20)
    ylim([0 100])
else
    h=bar(abs(Akmp)*1000);
    ylabel('Maximum deflection [mm]','InterPreter','LaTex','Fontsize',20)
end

% % colorbar;
% % for n=1:numel(h) 
% %     cdata=get(h(n),'ydata'); 
% %     set(h(n),'cdata',cdata,'facecolor','interp');
% % end
% % caxis([0 100]);
% % set(gca,'Ticklabelinterpreter','Latex','Fontsize',18)

xlabel('Mode number','InterPreter','LaTex','Fontsize',20)
% zlabel('Relative contribution [$\%$]','InterPreter','LaTex','Fontsize',20)
set(gcf,'units','normalized','position',[0 0 0.5 0.5],'color','white')

if options.title == 1
    title(options.titlename,'Interpreter','Latex','Fontsize',20);
end

if a.saveplots == 1
        fullfoldername = fullfile(a.plotfolder,options.specificfolder);
        if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
        figurename = [options.dataname '_contr'];
        fullfigurename = fullfile(fullfoldername, figurename);
        export_fig(fullfigurename,'-png','-eps')
end
