function plot_pshape3D(a,modes,defl,options)

% --- Set unallocated options to default ---
if nargin < 4; options = struct(); end
if isfield(options,'title') == 0;  if isfield(options,'titlename') == 1; options.title = 1; else options.title = 0; end; end
if isfield(options,'axis_normalised') == 0; options.axis_normalised = 0; end
if isfield(options,'dataname') == 0; options.dataname = 'Platestress'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = ''; end 
if isfield(options,'ylabelname') == 0; options.ylabelname = 'Deflection [m]'; end 
if isfield(options,'textfontsize') == 0; options.textfontsize = 20; end 
tfss = options.textfontsize;
tfsb = tfss+5;

% Processing
phasesign = real(sign(defl));
phasesign(isnan(phasesign)==1) = 0;
defl = abs(defl).*phasesign*10^3;

% Find min and maximum
max_disp = max(defl);
min_disp = min(defl);
if abs(min_disp)>1; min_disp_rounded = round(min_disp,1); elseif abs(min_disp)<1/1000; min_disp_rounded = round(min_disp); else min_disp_rounded = min_disp; end
if abs(max_disp)>1; max_disp_rounded = round(max_disp,1); else max_disp_rounded = max_disp; end

figure;
if options.axis_normalised == 1
    defl = defl/max(abs(defl));
    patch('Faces',modes.faces,'Vertices',modes.verts,'FaceVertexCData',defl,'FaceColor','interp');
    h = colorbar;
    caxis([-1 1])
    if min(min(w_amp_norm))<-0.01 
        if max(max(w_amp_norm))>0.01
        set(h, 'ylim', [-1 1]);
        else
        set(h, 'ylim', [-1 0]);
        end
    else
        set(h, 'ylim', [0 1]);
    end
end

if options.axis_normalised == 0
    patch('Faces',modes.faces,'Vertices',modes.verts,'FaceVertexCData',defl,'FaceColor','interp');
    h=colorbar;
    set(h, 'ylim', [min_disp_rounded max_disp_rounded]);
    caxis([min_disp_rounded max_disp_rounded]) 
    ytks = get(h,'YTick');
    if min_disp_rounded < (ytks(1))-0.33*abs((ytks(2)-ytks(1)))
        ytks = [min_disp_rounded ytks];
    end
    if max_disp_rounded > (ytks(end))+0.33*abs((ytks(2)-ytks(1)))
        ytks = [ytks max_disp_rounded];
    end
    set(h,'YTick',ytks);
end

% view([0.7 1.5 0.9])
view([0.9 1.4 0.9])
axis equal

set(gca,'Fontsize',14)
yl=ylabel(h,options.ylabelname);
set(yl,'Interpreter','Latex','Fontsize',tfsb);   
% xlabel('x-direction [m]','Interpreter','Latex','Fontsize',tfsb);
% ylabel('z-direction [m]','Interpreter','Latex','Fontsize',tfsb);
set(gcf, 'Color', 'w');
set(gca,'Ticklabelinterpreter','Latex','Fontsize',tfss)
set(gcf,'Units','Normalized','Position',[0.1 0.1 0.7 0.8])


if options.title == 1
    title(options.titlename,'Interpreter','Latex','Fontsize',tfsb);
end

colorbarpos=get(h,'Position');
gcapos = get(gca,'Position');
colorbarpos(1)=0.89*colorbarpos(1);
colorbarpos(2)=colorbarpos(2)+0.25;
colorbarpos(3)=0.6*colorbarpos(3);
colorbarpos(4)=colorbarpos(4)-0.25;
set(h,'Position',colorbarpos);

colorlabelpos=get(yl,'Position');
colorlabelpos(1)=1.2*colorlabelpos(1);
set(yl,'Position',colorlabelpos);

set(gca,'Position',gcapos);


if a.saveplots == 1
    fullfoldername = fullfile(a.plotfolder,options.specificfolder);
    if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
    figurename = options.dataname;
    fullfigurename = fullfile(fullfoldername, figurename);
    export_fig(fullfigurename,'-png')
end