function plot_fshape_contr(a,Bpr,options)

% --- Set unallocated options to default ---
if isfield(options,'title') == 0; 
    if isfield(options,'titlename') == 1; options.title = 1; else options.title = 0; end
end
if isfield(options,'dataname') == 0; options.dataname = 'Fluidshape_contr'; end 
if isfield(options,'specificfolder') == 0; options.specificfolder = ''; end 
if isfield(options,'nmodes_contr') == 0; options.nmodes_contr = 1000; else options.title = 0; end

% ---Check if requested modes to be plotted is below the number used in the calculations ---
if options.nmodes_contr > length(Bpr(:,1));
    options.nmodes_contr = length(Bpr(:,1));
end    

%Relative contributions of Bpr
[PP,RR] = meshgrid(1:1:options.nmodes_contr,1:1:options.nmodes_contr);
Bprp = Bpr(1:options.nmodes_contr,1:options.nmodes_contr);
Bprtot = sum(sum(abs(Bprp)));
ff=figure;
h=bar3(abs(Bprp)/Bprtot*100);
colorbar;
for n=1:numel(h) 
    cdata=get(h(n),'zdata'); 
    set(h(n),'cdata',cdata,'facecolor','interp');
end
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)
ylabel('Mode k (x-direction)','InterPreter','LaTex','Fontsize',17)
xlabel('Mode m (z-direction)','InterPreter','LaTex','Fontsize',17)
zlabel('Relative contribution [$\%$]','InterPreter','LaTex','Fontsize',17)
zlim([0 100])
set(gcf,'units','normalized','position',[0 0 0.6 1],'color','white')

if options.title == 1;
    title(options.titlename,'Interpreter','Latex','Fontsize',18);
end

if a.saveplots == 1;
        fullfoldername = fullfile(a.plotfolder,options.specificfolder);
        if ~exist(fullfoldername, 'dir'); mkdir(fullfoldername); end
        figurename = options.dataname;
        fullfigurename = fullfile(fullfoldername, figurename);
        export_fig(fullfigurename,'-png','-eps')
end
