function [a] = movie_fslices_subs(xs,zs,F,w_amp,max_w_amp,max_pf_amp,xf,zfR,BprR,kyR,PR,Omega,o,rhof,leftright,a,cc,f)

if a.submovie == 1
    
set(0,'DefaultFigureVisible','off')
if o == 1;
    a.vidobj = VideoWriter(['./movies/subplots_' datestr(now,'mmmm_dd_HH_MM') '.avi']);
    a.vidobj.FrameRate = 20*length(f.omegavec)/f.omegavec(end);
end
    open(a.vidobj);
    
%% Slice data
%fprintf('Computing slice data..\n')
tcomptic1 = tic;

 sxf = xf(1);
 Lxf = xf(end);
 Lzf = zfR(end);
 Lx = xs(end);
 Lz = zs(end);
    
yf = 0:cc.dy:40;
yslice_plot = [0 10 20 30 40];
PRy = zeros(length(xf),length(zfR),length(yf),cc.fmodes^2);
sumPRy = zeros(length(xf),length(zfR),length(yf),cc.fmodes^2);
a.tcomp1=toc(tcomptic1);
tcomptic2 = tic;
for pr = 1:cc.fmodes^2
    for i = 1:length(yslice_plot)
        PRy(:,:,(i-1)*10/cc.dy+1,pr) = PR(:,:,pr).*exp(-1j*kyR(pr)*yslice_plot(i));
    end
end
a.tcomp2=toc(tcomptic2);
tcomptic3 = tic;
for pr = 1:cc.fmodes^2
    for j = 1:length(yf)
            PRy(1,:,j,pr) = PR(1,:,pr).*exp(-1j*kyR(pr)*yf(j));
            PRy(:,1,j,pr) = PR(:,1,pr).*exp(-1j*kyR(pr)*yf(j));
    end
end
a.tcomp3=toc(tcomptic3);
for pr = 1:cc.fmodes^2
    sumPRy(:,:,:,pr) = PRy(:,:,:,pr)*BprR(pr);  
end

PRy_tot(:,:,:) = sum(sumPRy,4); % Quantified phi shape right at y = 0
pfRy_amp = abs(-1j*Omega*rhof*PRy_tot);
%% Start figure
%fprintf('Slice plot\n')
figure

%% Subplot fluid shape
% Plot slices
tplottic = tic;
pfRy_amp_plot = permute(pfRy_amp,[1 3 2]);
[Z,Y,X] = meshgrid(yf,xf,zfR);

subplot(3,7,[8:11 15:18])
slice(Z,Y,X,pfRy_amp_plot/max(max(max(abs(pfRy_amp_plot)))),yslice_plot,[sxf],[min(zfR)]); % Since only the slices that are plotted, are calculated, this assumes the maximum is in those planes. Generally this is the case (gate's surface).
xlabel('y-direction [m]','Interpreter','Latex','fontsize',15)
set(gca,'ztick',[0 Lzf],'xtick',[0 10 20 30 40],'ytick',[sxf Lxf]);
set(gca,'xticklabel',{'Gate','10','20','30','40'});
set(gca,'zticklabel',{'Sluice bottom','Still water level'});
set(gca,'yticklabel',{'Sluice wall','Sluice wall'});
set(gca,'fontsize',14,'ticklabelinterpreter','latex')
if a.title == 1; title('Fluid pressures $\tilde{p}/\tilde{p}_{max}$ [-]','Interpreter','Latex','fontsize',15);

% Plot grid
hold on; plot3([0 0],[sxf Lxf],[0 0],'k','LineWidth',0.5);
for j = 1:length(yslice_plot)
hold on; plot3([yslice_plot(j) yslice_plot(j)],[sxf sxf],[0 Lzf],'k','LineWidth',0.5);
hold on; plot3([yslice_plot(j) yslice_plot(j)],[sxf Lxf],[0 0],'k','LineWidth',0.5);
hold on; plot3([yslice_plot(j) yslice_plot(j)],[Lxf Lxf],[0 Lzf],'k','LineWidth',0.5);
hold on; plot3([yslice_plot(j) yslice_plot(j)],[sxf Lxf],[Lzf Lzf],'k','LineWidth',0.5);
end
hold on; plot3([0 yf(end)],[sxf sxf],[0 0],'k','LineWidth',0.5);
hold on; plot3([0 yf(end)],[sxf sxf],[Lzf Lzf],'k','LineWidth',0.5);

% Appearance
view(131,31)
axis equal
cb = colorbar; colormap(jet)
set(cb, 'lim', [0 1]);
caxis([0 1])
set(findobj(gca,'Type','Surface'),'EdgeColor','none');

%% Subplot deflection shape
% Find number of peaks to determine amount of contour lines
w_pks1 = findpeaks(w_amp(round(size(w_amp,2)/11),:));
w_pks2 = findpeaks(w_amp(:,round(size(w_amp,1)/11)));
w_pks = length(w_pks1)*length(w_pks2);
ncontlines = max(22-w_pks*1.5,12);

% Plot shape
subplot(3,7,[12:14 19:21])
w_amp = flip(w_amp,1);
contourf(xs,zs,w_amp.'/max(max(w_amp)),ncontlines); hold on; % ,round(26-1.5*o)
set(gca,'Ticklabelinterpreter','Latex','Fontsize',14)
set(gca,'ytick',[],'xtick',[])
if a.title == 1; title('Plate deflection $\tilde{w}/\tilde{w}_{max}$ [-]','Interpreter','Latex','Fontsize',18); end

% Appearance
axis equal
h = colorbar;
set(h, 'ylim', [0 1]);
colormap(jet)
caxis([-1 1])
%% Subplot force
subplot(3,7,[1:3])
F = flip(F,1);
contourf(xs,zs,F(:,:,1,1)',10)
axis equal
colormap(jet)
h=colorbar;
set(h, 'ylim', [0 1]);
caxis([-1 1])
set(gca,'Ticklabelinterpreter','Latex','Fontsize',14)
set(gca,'ytick',[],'xtick',[])
if a.title == 1; title('Force amplitude shape [N/m$^2$]','Interpreter','Latex','Fontsize',18); end
set(gca,'Ticklabelinterpreter','Latex','Fontsize',15)

%% Subplot maxima deflection and fluid over omega range
subplot(3,7,[4:7])
yyaxis left
f.omegavec = f.omegavec/(2*pi);
plot(f.omegavec(1:o),max_w_amp,'-b','LineWidth',1); hold on
xlim([0 max(f.omegavec)])
if isempty(a.pmotion_ylim) == 0;
    ylim(a.pmotion_ylim(1,:))
end
xtickvec = [0:max(f.omegavec)/10:max(f.omegavec) round(f.omegavec(o),1)];
xtickvec = sort(xtickvec);
xtickvec = unique(xtickvec);
index = find(xtickvec==round(f.omegavec(o),1));
if index > 1 && index < length(xtickvec)
    if abs(xtickvec(index-1)-f.omegavec(o)) < max(f.omegavec)/20
        xtickvec(index-1) = [];
    else
        xtickvec(index+1) = [];
    end
end 
set(gca,'xtick',xtickvec);
xlabel('Excitation frequency [Hz]','InterPreter','LaTex','Fontsize',15)
ylabel('$\tilde{w}_{max}$ (m)','InterPreter','LaTex','Fontsize',15);
set(gca,'TicklabelInterPreter','LaTex','Fontsize',14)
grid on
set(gca,'Ycolor',[0 0 1]);
yyaxis right
set(gca,'Ycolor',[1 0 0]);
plot(f.omegavec(1:o),max_pf_amp,'-r','LineWidth',1); hold on
plot(f.omegavec(o),max_pf_amp(o),'*r','LineWidth',0.5); hold on
if isempty(a.fmotion_ylim) == 0;
    ylim(a.fmotion_ylim(2,:))
end
ylabel('$\tilde{p}_{max}$ (N/m$^2$)','InterPreter','LaTex','Fontsize',15);
legendInfo{1} = 'Max. plate deflection';
legendInfo{2} = 'Max. fluid pressure';
ll=legend(legendInfo);
set(ll,'InterPreter','LaTex','Fontsize',12)
yyaxis left
plot(f.omegavec(o),max_w_amp(o),'*b','LineWidth',0.5); hold on
a.tplot = toc(tplottic);
%% Figure appearance and video writing
% Super title
% st = suptitle(['Excitation frequency $\omega =$ ' num2str(round(Omega)) ' rad/s']);
% set(st,'Interpreter','Latex','fontsize',20)
tsavetic = tic;
set(gcf,'units','normalized','outerposition',[0 0 1 6/7])
ax = gca;
ax.NextPlot = 'replaceChildren';
frame = getframe(gcf);
writeVideo(a.vidobj,frame)
close all;
a.tsave = toc(tsavetic);
end

set(0,'DefaultFigureVisible','on')
end