function f = forceshape_round(v,cc,f,xm_fac,zm_fac,r,Amp)
if nargin<4;
    amp = 1;
end

v.xs = linspace(0,v.Lx,v.Lx/cc.dx+1);
v.zs = linspace(0,v.Lz,v.Lz/cc.dz+1);

%% Shape impact
% % Midpoint force
xm = xm_fac*v.Lx;
zm = zm_fac*v.Lz;
% r = 2;
% Amp = amp;

Famp = zeros(round(v.Lx/cc.dx+1),round(v.Lz/cc.dz+1),1,1);
xs = v.xs;
zs = v.zs;

for i = 1:((v.Lx/cc.dx)+1)
    for j = 1:((v.Lz/cc.dz)+1)
        if (r-(abs(xs(i)-xm)^2+abs(zs(j)-zm)^2)^0.5) > 0
            Famp(i,j,1,1) = Amp*(r-(abs(xs(i)-xm)^2+abs(zs(j)-zm)^2)^0.5)/sqrt(2);
        else
            Famp(i,j,1,1) = 0;
        end
    end
end
f.F = Famp;