function f = forceshape_hydrostatic(v,cc,f)

pf_L = zeros(round(v.Lx/cc.dx+1),round(v.Lz/cc.dz+1));
pf_R = zeros(round(v.Lx/cc.dx+1),round(v.Lz/cc.dz+1));

for i = 1:(v.f3.h/cc.dz+1)
    pf_L(:,i) = v.f3.rhof*v.g*(v.f3.h-(i-1)*cc.dz);
end
for i = 1:(v.f1.h/cc.dz+1)
    pf_R(:,i) = v.f1.rhof*v.g*(v.f1.h-(i-1)*cc.dz);
end

pf_Res = pf_R-pf_L;
f.F(:,:,1,1) = pf_Res;
end