function f = fshape_impulseimpact(v,cc,f)

%% Shape impact
% Midpoint force
xm = 0.6*v.Lx;
zm = 0.6*v.Lz;
r = 2;
Amp = 1;

Famp = zeros(v.Lx/cc.dx+1,v.Lz/cc.dz+1,1,1);
xs = v.xs;
zs = v.zs;

for i = 1:((v.Lx/cc.dx)+1)
    for j = 1:((v.Lz/cc.dz)+1)
        if (r-(abs(xs(i)-xm)^2+abs(zs(j)-zm)^2)^0.5) > 0
            Famp(i,j,1,1) = Amp*(r-(abs(xs(i)-xm)^2+abs(zs(j)-zm)^2)^0.5)/sqrt(2);
        else
            Famp(i,j,1,1) = 0;
        end
    end
end
f.F = Famp;