function imp_vertical = woodandperigrine(a,dz)
% Implementation of wave impact under an overhang
% as published by Wood&Peregrine, Wave impact beneath a horizontal surface. ICCE1996
% Bas Hofland 2019

%% Input

% input with dimensions
Vdim   = 1.0; % impact velocity, m/s
% Ldim   = 1;

%% Analytical solution
% adim   = ohs(r); % overhang height, m

% make dimensionless variables
% a      = adim/Ldim;
width  = 10;

x = (0:0.005:width)'*ones(1,round((1/dz)*a)+1);
y = ones(200*width+1,1)*(0:dz:a);
z = x + 1j*y;

%STEP 1 - CONFORMAL MAP 1
w = cosh(pi*z/a);

%STEP 2 - TRANSLATION AND MAGNIFICATION
M = 2/(cosh(pi/a)-1);
N = M + 1;
h = M*w + N; 

%STEP 3 - CONFORMAL MAP 2
zeta = a*acosh(h)/pi; 
ksi = real(zeta);
eta = imag(zeta);

% set variables for integration over eta
Nint     = 1000;
deta_int = a/Nint;
eta_int  = ((1:Nint)-1/2)'*deta_int;
b_int    = (cos(pi*eta_int/a)-N)/M ;

% reconstruct P by adding Fourier modes
P = 0;

for n = 1:30
    alphan = (n-1 + 1/2)*pi/a; % I sum from n=0 , so take n-1 such that n can be used as index
    % numerical integration to determine Fourier coefficients
    An(n) = 2/alphan/a * sum( sin(pi*eta_int/a).*cos(alphan*eta_int)./sqrt(b_int.^2-1) / M ) * deta_int ; % says Am in paper, I not see where a comes from
    % sum Fourier modes to get P
    P = P + An(n) * cos(alphan*eta) .* exp(-alphan*ksi) ; % not sure about the real() in right expression in paper
end

imp_vertical = P(1,:);