function [modes] = Optimization_SCIA(v,cc)
figures = 0;             % 1 will create figures for polynomial analysis
XLS = [];
%Total amount of structural modes
Smodes = cc.smodes;
 
%Adapt Parameters to fit Scia model and calculate every variation
modes.modes = [];

%Position of variables in the xml file
Pos = linspace(0,length(v.Sizes)-1,length(v.Sizes));

%Set num variables to string
for i = 1:length(v.Par)
    A = strrep(num2str(v.Par(i)),'.',',');
    Varxml{i} = {A};
end

% Finding location of the variable
if v.case == 1
    xmlNode = xmlread('.\SCIALink\SCIA_solidplate.xml');
elseif v.case == 2
    xmlNode = xmlread('.\SCIALink\SCIA_reinforcedplate.xml');
else
    xmlNode = xmlread('.\SCIALink\SCIA.xml');
end
for i = 1:length(Pos)
    a = xmlNode.getElementsByTagName('project');
    b = a.item(0).getElementsByTagName('container');
    c = b.item(0).getElementsByTagName('table');
    d = c.item(0).getElementsByTagName('obj');
    e = d.item(Pos(i)).getElementsByTagName('p5');
    f = e.item(0).getElementsByTagName('row');
    g = f.item(0).getElementsByTagName('p0');
    g.item(0).setAttribute('v',Varxml{i});
end

%Run SCIA with the new variables through a bash-script with the xml-file
if v.case == 1
    %Rewrite the xml-file with the new variables
    xmlwrite('.\SCIALink\SCIA_solidplate.xml', xmlNode);
    filepath = 'cscript .\SCIALink\Mod_SCIA_solidplate.vbs';
elseif v.case == 2
    %Rewrite the xml-file with the new variables
    xmlwrite('.\SCIALink\SCIA_reinforcedplate.xml', xmlNode);
    filepath = 'cscript .\SCIALink\Mod_SCIA_reinforcedplate.vbs';
else
    %Rewrite the xml-file with the new variables
    xmlwrite('.\SCIALink\SCIA.xml', xmlNode);
    filepath = 'cscript .\SCIALink\Mod_SCIA.vbs';
end

system(filepath);
fprintf('SCIA-calculation has completed for generation %d\n', v.var);
fprintf('Retrieving data from xml-file. . . \n');

system('taskkill /F /IM EXCEL.EXE'); %Kills excel to reduce the use of the memory

xml = xml2struct('.\SCIALink\SCIAResultaten.xml');

modes.frequency = zeros(Smodes, 1);
for i = 1:Smodes
    modes.frequency(i,1) = str2double(xml.project.container{1}.container.table.obj.p0.row.p1{i}.Attributes.v);
end

m = length(xml.project.container{2}.table.obj.p0.row);
x = [];
y = [];
z = [];
for i = 1:m
    if str2double(xml.project.container{2}.table.obj.p0.row{i}.p3.Attributes.v) == 0
        x(i) = str2double(xml.project.container{2}.table.obj.p0.row{i}.p2.Attributes.v);
        y(i) = str2double(xml.project.container{2}.table.obj.p0.row{i}.p3.Attributes.v);
        z(i) = str2double(xml.project.container{2}.table.obj.p0.row{i}.p4.Attributes.v);
        for k = 1:Smodes
            Uy{k}(i) = str2double(xml.project.container{1+k}.table.obj.p0.row{i}.p7.Attributes.v);
        end
    end
end

[verts, faces, col_disp, col_stress, col_stress_neg, col_tmax] = Display_3dObjects(xml, modes);
modes.verts = verts; modes.faces = faces; modes.col_disp = col_disp; 
modes.col_stress = col_stress; modes.col_stress_neg = col_stress_neg;
modes.col_tmax = col_tmax;

if figures == 1
    figure;
    p = patch('Faces',faces,'Vertices',verts,'FaceVertexCData',col_stress(:,1),'FaceColor','interp');
    view([1 1 1])
    axis equal off
    % p.FaceAlpha = 0.4;
    p.LineStyle = 'none';
end

Vq = [];
for k = 1:Smodes
    xdv = linspace(round(min(x(:)),2), round(max(x(:)),2), round(max(x(:)),2)/cc.dx+1);
    zdv = linspace(round(min(z(:)),2), round(max(z(:)),2), round(max(z(:)),2)/cc.dz+1);
    [Xd,Zd] = meshgrid(xdv, zdv);
    F = scatteredInterpolant(x(:),z(:),Uy{k}(:));  %/max(abs(U_max)
    Vq(:,:,k) = F(Xd,Zd);
end

Vxz = permute(Vq,[2,1,3]);
[X,Z] = meshgrid(zdv, xdv);

% Raw data interpolated
if figures == 1
    figure;
    surf(X, Z, Vxz(:,:,1));
end

function [res] = polyinterp(Vxz, Smodes, figures, X, Z)
    %% compute the 2D polynomial approximation.
    degreeX = 16;    %16
    degreeY = 16;    %16

    nrBfsX = degreeX + 1;
    nrBfsY = degreeY + 1;

    modes.Y2 = [];
    modes.S = [];
    for i = 1:Smodes
        [Y2, S] = dop2DApprox( Vxz(:,:,i), nrBfsX, nrBfsY );
        modes.Y2(:,:,i) = Y2;
        modes.S(:,:,i) = S;
    end

    % 2D polynomial approximation
    if figures == 1
        figure;
        surf(X, Z, modes.Y2(:,:,2));
    end

    %% 2D Polynomials Spectrum 
    specX = 0:(nrBfsX-1);
    specY = 0:(nrBfsY-1);
    modes.S(1,1,:) = 0;
    if figures == 1
        figure;
        imagesc( specX, specY, modes.S(:,:,1) );
        title('2D Polynomial Spectrum');
        xlabel('Polynomial degree in x');
        ylabel('Polynomial degree in y');
        colorbar;
    end

    %% Present the Surface Anomalies 
    % Compute the difference between the 2D approximation and the original surface.
    modes.L = [];
    for i = 1:Smodes
        modes.L(:,:,i) = Vxz(:,:,i) - modes.Y2(:,:,i);
    end
    
    res = modes.Y2;
    
    if figures == 1
        figure;
        subplot(2,1,1);
        surf(X, Z, modes.Y2(:,:,1) );
        title('2D approximation');
        axis image;
        ylabel('y [m]');
        colorbar;

        subplot(2,1,2);
        surf(X, Z, modes.L(:,:,1) );
        title('Local error');
        axis image;
        xlabel('x [m]');
        ylabel('y [m]');
        colorbar;
    end
end

[modes.Wxz] = polyinterp(Vxz, Smodes, figures, X, Z)*-1;
% [modes.Wxz] = polyinterp(Vxz, Smodes, figures, X, Z)*-1;

for i = 1:Smodes
    T = table(modes.Wxz(:,:,i));
    path = ['.\Modes\mode' num2str(i) '.xlsx'];
    writetable(T, path);
end

T = table(modes.frequency);
path = ['.\Modes\frequencies.xlsx'];
writetable(T, path);

T = table(modes.verts);
path = ['.\Modes\verts.xlsx'];
writetable(T, path);

T = table(modes.faces);
path = ['.\Modes\faces.xlsx'];
writetable(T, path);

T = table(modes.col_disp);
path = ['.\Modes\coldisp.xlsx'];
writetable(T, path);

T = table(modes.col_stress);
path = ['.\Modes\colstress.xlsx'];
writetable(T, path);

T = table(modes.col_stress_neg);
path = ['.\Modes\colstressneg.xlsx'];
writetable(T, path);

T = table(modes.col_tmax);
path = ['.\Modes\coltmax.xlsx'];
writetable(T, path);

fprintf('%d Modal shapes have been calculated\n', Smodes);
end