function [verts, faces, col_disp, col_stress, col_stress_neg, col_tmax] = Display_3dObjects(xml, modes)
figures = 0;             % 1 will create figures for polynomial analysis

N = 10;

m = length(xml.project.container{18}.table.obj.p1.row);
x_s = []; y_s = []; z_s = []; element = []; node = [];

for i = 1:m
    x_s(i) = str2double(xml.project.container{18}.table.obj.p1.row{i}.p2.Attributes.v);
    y_s(i) = str2double(xml.project.container{18}.table.obj.p1.row{i}.p3.Attributes.v);
    z_s(i) = str2double(xml.project.container{18}.table.obj.p1.row{i}.p4.Attributes.v);
    rawtext = xml.project.container{18}.table.obj.p1.row{i}.p1.Attributes.v;
    values = str2double(regexp(rawtext, '\d+', 'match'));
    element(i) = values(1);
    node(i) = values(2);
end

N_verts = length(unique(node));
N_faces = length(unique(element));

verts = zeros(N_verts, 3);
faces = zeros(N_faces, 4);
col = zeros(N_verts, 1);

node_count = 1;
for i = 1:m
    verts(node(i),1) = x_s(i);
    verts(node(i),2) = y_s(i);
    verts(node(i),3) = z_s(i);
    if node_count == 1
        faces(element(i),1) = node(i);
        node_count = 2;
    elseif node_count == 2
        faces(element(i),2) = node(i);
        node_count = 3;
    elseif node_count == 3
        faces(element(i),3) = node(i);
        node_count = 4;
    elseif node_count == 4
        faces(element(i),4) = node(i);
        node_count = 1;
    end
end

%% displacement plots
col_disp = zeros(N_verts, length(modes.frequency));

m = length(xml.project.container{2}.table.obj.p0.row);

for k = 1:length(modes.frequency)
    for i = 1:m
        rawtext = xml.project.container{1+k}.table.obj.p0.row{i}.p1.Attributes.v;
        values = str2double(regexp(rawtext, '\d+', 'match'));
        if abs(col_disp(values(1),k)) < abs(str2double(xml.project.container{1+k}.table.obj.p0.row{i}.p7.Attributes.v))
            col_disp(values(1),k) = str2double(xml.project.container{1+k}.table.obj.p0.row{i}.p7.Attributes.v);
        end
    end
end

if figures == 1
    figure;
    p = patch('Faces',faces,'Vertices',verts,'FaceVertexCData',col_disp(:,1),'FaceColor','interp');
    view([1 1 1])
    axis equal off
    % p.FaceAlpha = 0.4;
    p.LineStyle = 'none';
end

%% stress plots
col_stress = zeros(N_verts, length(modes.frequency));

m = length(xml.project.container{18}.table.obj.p1.row);

for k = 1:length(modes.frequency)
    for i = 1:m
        rawtext = xml.project.container{17+k}.table.obj.p1.row{i}.p1.Attributes.v;
        values = str2double(regexp(rawtext, '\d+', 'match'));
        if abs(col_stress(values(2),k)) < abs(str2double(xml.project.container{17+k}.table.obj.p1.row{i}.p10.Attributes.v))
            col_stress(values(2),k) = str2double(xml.project.container{17+k}.table.obj.p1.row{i}.p10.Attributes.v);
        end
    end
end

if figures == 1
    figure;
    p = patch('Faces',faces,'Vertices',verts,'FaceVertexCData',col_stress(:,1),'FaceColor','interp');
    view([1 1 1])
    axis equal off
    % p.FaceAlpha = 0.4;
    p.LineStyle = 'none';
end

col_stress_neg = zeros(N_verts, length(modes.frequency));

for k = 1:length(modes.frequency)
    for i = 1:m
        rawtext = xml.project.container{17+k}.table.obj.p1.row{i}.p1.Attributes.v;
        values = str2double(regexp(rawtext, '\d+', 'match'));
        if abs(col_stress_neg(values(2),k)) < abs(str2double(xml.project.container{17+k}.table.obj.p1.row{i}.p11.Attributes.v))
            col_stress_neg(values(2),k) = str2double(xml.project.container{17+k}.table.obj.p1.row{i}.p11.Attributes.v);
        end
    end
end

col_tmax = zeros(N_verts, length(modes.frequency));

for k = 1:length(modes.frequency)
    for i = 1:m
        rawtext = xml.project.container{17+k}.table.obj.p1.row{i}.p1.Attributes.v;
        values = str2double(regexp(rawtext, '\d+', 'match'));
        if abs(col_tmax(values(2),k)) < abs(str2double(xml.project.container{17+k}.table.obj.p1.row{i}.p14.Attributes.v))
            col_tmax(values(2),k) = str2double(xml.project.container{17+k}.table.obj.p1.row{i}.p14.Attributes.v);
        end
    end
end

end