import numpy as np
import matplotlib.pyplot as plt
import matplotlib.path as path

z = np.loadtxt('ldos_scat.dat') 

# Plot
#cm = "Greys"
cm = "viridis"
fig, ax = plt.subplots(figsize = (12,6))

# ensure positive charge density
for i in range(len(z[:,2])):
    z[i,2]=max(z[i,2],0.00000001)

to_plot = np.log(z[:,2])
vmin = -2
vmax =  1
dx = 0.2
dy = 0.1
vert = list(zip([-dx,dx,dx,-dx],[-dy,-dy,dy,dy]))
bc=ax.scatter(z[:,0],z[:,1],c=to_plot,s=70,cmap=cm,vmin=vmin, vmax=vmax, marker = (vert,0))
cbar=plt.colorbar(bc,ticks=[vmin,vmax], shrink=0.7, pad = 0.1)
cbar.ax.set_yticklabels([vmin,vmax],size=20)
cbar.ax.set_ylabel(r"$\log(lDOS)$", rotation=270,size=20)

ax.set_xlim(0.0,539)
ax.set_ylim(5,6)

ax.set_ylabel(r"$E(eV)$",size=20)
ax.tick_params(axis='both', which='major', labelsize=18)
ax.xaxis.set_visible(False)

# make an PDF figure of a plot
fig.tight_layout()
fig.savefig("ldos_scat.png")
