function [] = plotWires(x,y,d,ax,pointStyle,lineStyle,lineWidth,edgecolor)
%PLOTWIRES plots wires as circles in a figure

%Inputs
%-x and y give the position of the wires
%-d defines the diameter of the wires
%-[optional] figure/axis handle to plot in (if empty hold on is used)
%-[optional] pointStyle defines the style to mark centers, if empty,
%  no points are plotted. OR the electrode number of the wire (array)
%-[optional] lineStyle defines the linestyle of the circles
%-[optional] linewidth defines the width of the circle lines.
%This function has no outputs, the result is directly plotted on the figure
%-pointStyle can also be an array containing an array of structure
%numbers for different colors. 


%% Check inputs
if nargin < 3
    error('Not enough input arguments')
end
if length(x) ~= length(y) 
    error('Inconsistent number of wires (x and y have different dimensions)')
end


struct = ones(size(x));
if nargin >= 5 && ~ischar(pointStyle)
    struct = pointStyle;
    pointStyle = 'r*';
end

%set alternativer values
if nargin < 8
    edgecolor = {[0,0,0],[1,0,0],[0,0,1],[0,1,0]};
    if nargin < 7
        lineWidth = 2;
        if nargin < 6
            lineStyle = '-';
            if nargin < 5 
                pointStyle = '*';
            end
        end
    end
end
setprop = false;

if nargin <= 3 || isempty(ax)
    ax = gca;
    hold on
    axis equal
    setprop = true;
end
if  strcmp(get(ax,'type'),'figure')
     setprop = true;
     ax = get(ax,'CurrentAxes');
     hold on
end

if ~iscell(edgecolor)
    edgecolor = {edgecolor};
end



%% plot circles
for i = 1:length(x)
   %plot circle using the rectangle function
   pos = [x(i)-d/2, y(i)-d/2, d,d];
   rectangle(ax,'Position',pos,'Curvature',[1 1],'lineStyle',lineStyle,'edgecolor',edgecolor{struct(i)+1},'LineWidth',lineWidth)
   % plot centers
   if ~isequal(pointStyle,[])
       plot(ax,x(i),y(i),pointStyle,'Color',edgecolor{struct(i)+1})
   end
end




if setprop
    axis equal
    hold off
    ylim([min(y)-d,max(y)+d])
end


end

