function [weight,reldist] = interpolateClosestValues(xM,x0,ilist,varargin)
%INTERPOLATE CLOSEST VALUES prepare linear interpolation on an
%unsorted list of (x,y) coordinates by choosing the coordinates
%closest to x0 in both direcions ant interpolating between those.
%Returns an array with the same length containing 2 nonzero values
%which correspond to the weight of both values. To get the final
%interpolation value use weight.*y. If xM is a matrix this will be
%performed for any list in the last dimension, the indexes in i in the
%first n-1 dimensions will be used to select for which lists we need
%to apply this.

allowExtrapolate = false;
i = 0;
while i < length(varargin)
    i = i + 1;
    in = varargin{i};
    if strcmp(in,'allowExtrapolate')
        %option to only return maximum y position (for use in
        %optimization function)
        allowExtrapolate = true;
    else
        warning(['Unknown option ', in,' is ignored'])
    end
end  


sz = size(xM);
weight = zeros(sz);
if ~exist('ilist','var')||isempty(ilist)
    ilist = 1:prod(sz(1:end-1));
end

%loop over the elements in all dimensions but the last one
for i = ilist
    %trick to get a list in the last dimension
    x = xM(i:prod(sz(1:end-1),'all'):prod(sz,'all'));
    %check if the value is in the array itself
    if any(x==x0)
        indLow = find(x==x0);
        weight((i) + prod(sz(1:end-1),'all')*(indLow-1)) = 1;
        reldist(i) = 0;
        continue
    end
    
    ind = (x-x0)>0;
    temp = x;
    temp(ind) = NaN;
    [xLow,indLow] = max(temp);
    temp = x;
    temp(~ind) = NaN;
    [xHigh,indHigh] = min(temp);
    
    if isnan(xHigh) || isnan(xLow)
        if ~allowExtrapolate 
        %otherwise we find the closest value in each direction
            reldist = NaN;
            weight = NaN;
            return
        else

        end
    end
    
    %find an associated weights
    b = (x0-xLow)/(xHigh-xLow);
    weight((i) + prod(sz(1:end-1),'all')*(indLow-1)) = 1-b;
    weight((i) + prod(sz(1:end-1),'all')*(indHigh-1)) = b;
    reldist(i) = min(abs(x([indLow,indHigh])-x0)/(max([x,0])-min([x,0])));

end