function saveFigure(ax,type,filename)
%SAVEFIGURE save the current figure, or a UI figure (in the app) as
%csv or fig file. ax specifies a UI-axis or axis object (for the
%current figure, use gca). Type specifies the output type: 3 for a
%csv, 2 for a figure and 1 to open a figure. Filename specifies the
%filename (without filetype!).
    
    %Modified from:  Adam Danz (2021). copyUIAxes 
    %(https://www.mathworks.com/matlabcentral/fileexchange/73103-copyuiaxes), 
    %MATLAB Central File Exchange. Retrieved March 17, 2021. 
    try
        h = copyUIAxes(ax);
    catch
        h = ax;
    end
    
    if type == 1
        return
    end
    if type == 2 
        %save as a figure
        savefig(fig, fileName);
    end
    if type == 3
        %we need to make a csv
%         ch = get(h.axes,'Children');
        try
            ch = get(h,'Children');
        catch
            ch = get(ax,'Children');
        end
        c = ch;
        data = [];
        colnames = {};
        header = '';
        j = 1;
        for i = 1:size(c)
            type = get(c(i),'type');
            if strcmp(type,'surface')
                csv_3D([filename,'.csv'],c(i).XData,c(i).YData,c(i).ZData)
                delete(h.figure);
                return
            elseif strcmp(type,'line')
                x = c(i).XData';
                y = c(i).YData';
                %make the vectors equal length
                sizediff =  length(x)- size(data,1);
                if sizediff > 0 && size(data,1) ~= 0 
                    data = padarray(data,sizediff,NaN,'post');
                elseif sizediff < 0 && size(data,1) ~= 0
                    x = padarray(x,-sizediff,NaN,'post');
                    y = padarray(y,-sizediff,NaN,'post');
                end
                %put all data in one matrix (that will be put in csv)
                data = [data,x];
                data = [data,y];
                %get name from the tag (if used)
                colname1 = get(c(i),'tag');
                colname = colname1;
                k = 1;
                while ismember(colname,colnames)
                    k = k + 1;
                    colname = [colname1,num2str(k)];
                end                
                colnames{j} = colname;
                j = j + 1;
                header = [header,'x',colname,',','y',colname,','];
            else
            end
        end
        outF =  [filename,'.csv'];
        header = [header(1:end-1),'\n'];
        f = fopen(outF, 'w');fprintf(f, header);fclose(f);
        % write data
        dlmwrite(outF,data,'-append','delimiter',',');
    end
    

    
    % Delete the temporary figure.
     try
         delete(h.figure);
     catch
     end
end

