%This script can be used to precalculate common data of the hyperelastic
%beam model as these calculations are rather slow. 
%For maxerr = 10 and 20, datafiles are included. It is recommended to
%only run this script if you really need to have this with another
%value for the maximum error.

clear;
close all;
clc;


mu = 1.32e8; %  %Initial shear modulus [Pa] (value for Armadillo TPU)
E = 2*(1.5)*mu; %Youngs modulus assuming incompressibility
L = 1; %length of the beam (we use ratios)

xlabel('n')
ylabel('H/L [-]')
grid minor
ydata = [];
maxErrList = [0.2,0.1,0.05];

for maxErr = 0.2 %allowed deviations in y displacement due to 
          %pressures relative to the y-displacement at 0 pressure [-];
    tic
    nlist = 2.15:0.1:2.5;
%     nlist = [1:0.05:2,2.1:.1:15,15.2:0.2:25]; 
    Hlist = NaN(1,length(nlist));
    wopen = Hlist;
    for i = 1:length(nlist)
        n = nlist(i);
        %Select peak shear stress and pressure
        P = -740e3*n; %pressure [Pa] (Peak value from Wang2020)
        Q = 140e3*n; %shear stress [Pa] (Peak value from Wang2020)
        relDiff = @(a,b) abs(a-b)/a;
        %optimization function: set the relative difference between 0
        %pressure and n*740kPa to maxErr
        options = optimoptions('fsolve','Display','iter','DiffMaxChange',0.1);
        fun = @(H) abs(relDiff(neoHookean(L,H,Q/mu,0,'reduceOutput'),...
            neoHookean(L,H,Q/mu,P/mu,'reduceOutput'))-maxErr);   
        if i == 1
            guess = 0.1;
        else
            guess = Hlist(i-1);
        end
        Hlist(i) = fsolve(fun,guess,options);

        wopen(i) = (nlist(i)-1)*2*Hlist(i) + neoHookean(L,Hlist(i),Q/mu,P/mu,'reduceOutput');
%         Hlist(i) = fmincon(fun,0.1,[],[],[],[],0,0.6,[],options); 
        
        plot(nlist,Hlist)
        drawnow
        if isnan(Hlist(i))
            a = 'done';
        end
        %calculate and save the deformations
        for Pmu = [0,P,1.05*P]/mu
            Qmu = linspace(0,Q/mu*1.04,26);
            saveDeformation(Hlist(i),Pmu,Qmu,maxErr*100,'message')
        end
    end
    toc
    plot(nlist,Hlist)
    ydata = [ydata,Hlist',wopen'];
end

%save the file here (commented to prevent overwriting a file by accident)
%recommended to save as optimalWidthsLargeXX where XX is the allowed
%deviation in percentage. E.g. for 20%:
% save optimalWidthsLarge20