function [u,v] = findDeformation(Hratio,P_mu,Q_mu,xbeam,ybeam,desErr,varargin)
%FINDDEFORMATION finds the deformation of a point on a beam with
%width H at coordinates (xbeam,ybeam) wrt the coordinate frame of
%the beam and returns the deformation x and y direction. Qmu and Pmu
%are the shear stress and tensile stress (or if negative, pressure) 
%respectively.
%As calculations are rather slow, we save our calculation results and
%interpolate if possible to get a quick result.

maxdist = 0.1;
if ybeam ~= 0
    warning('function cannot handle ybeam values other than 0 yet, I will set ybeam = 0 and continue\n')
    ybeam = 0;
end

%Check if the datafile exists and load it, otherwise calculate and
%create a datafile
try
    load('DeformationData','Hlist','Plist','Qlist','udata','vdata',...
    'thetadata','lambdadata','alphadata','kdata','designErr'); 
catch
    saveDeformation(Hratio,P_mu,Q_mu,desErr,'message')
    load('DeformationData','Hlist','Plist','Qlist','udata','vdata',...
    'thetadata','lambdadata','alphadata','kdata','designErr'); 
end

%preallocation
u = NaN(length(Hratio),length(P_mu),length(Q_mu),length(xbeam));
v = u;

xlist = reshape(linspace(0,1,50),1,1,1,[]);

i = 0;
for H = Hratio
    i = i + 1;
    % check which H-index to use
    %only use points generated using the same designerror:
    use = NaN(size(Hlist));
    use(designErr == desErr) = 1;
    %all values of H that are not suitable to use are replaced by NaNs
    [Hind,reldist] = interpolateClosestValues(Hlist.*use,H);
    if ~(all(reldist < maxdist)) || isempty(Hlist)
        %do a new calculation
        saveDeformation(H,P_mu,Q_mu,desErr,'message')
        %reload the updated data:
            load('DeformationData','Hlist','Plist','Qlist','udata',...
                'vdata','thetadata','lambdadata','alphadata','kdata','designErr'); 
        %find the index in the new list
        [Hind,~] = interpolateClosestValues(Hlist,H);
    end
    
    j = 0;
    for Pmu = P_mu
        j = j + 1;
        [Pind,reldist] = interpolateClosestValues(Plist,Pmu,find(Hind~=0));
        if ~(all(reldist < maxdist)) || isempty(Plist(~isnan(Plist)))
            %do a new calculation
            saveDeformation(Hlist(Hind~=0),Pmu,Q_mu,desErr,'message')
            %reload the updated data:
            load('DeformationData','Hlist','Plist','Qlist','udata',...
                'vdata','thetadata','lambdadata','alphadata','kdata','designErr'); 
            %find the index in the new list
            [Pind,~] = interpolateClosestValues(Plist,Pmu,find(Hind~=0));
        end
        
        k = 0;
        for Qmu = Q_mu
            k = k + 1;
            [Qind,reldist] = interpolateClosestValues(Qlist,Qmu,find(Pind~=0));
            if ~(all(reldist < maxdist)) || isempty(Qlist(~isnan(Qlist)))
                %do a new calculation
                saveDeformation(Hlist(Hind~=0),Plist(Pind~=0),Qmu,desErr,'message')
                %reload the updated data:
                load('DeformationData','Hlist','Plist','Qlist','udata',...
                    'vdata','thetadata','lambdadata','alphadata','kdata','designErr'); 
                %find the index in the new list
                [Qind,reldist] = interpolateClosestValues(Qlist,Qmu,find(Pind~=0));
            end
            
            l = 0;
            for x = xbeam
                l = l + 1;
                if x > 1 || x < 0
                    error('invalid x value entered')
                end
                xind = interpolateClosestValues(xlist,x);
                
                %look up the weithted value:
                u(i,j,k,l) = sum(udata .* (Hind' .* Pind .* Qind .* xind),'all','omitnan');
                v(i,j,k,l) = sum(vdata .* (Hind' .* Pind .* Qind .* xind),'all','omitnan');
            end                           
        end
    end
end



end





