function [ypos,xpos,U] = createWireStructure(nGroupsTop,nGroupsBot,nInGroup,syGroups,syInGroup,Sx)
%CREATEWIRESTRUCTURE Defines a structure in x and y coordinates
% based upon the parameters of as in the electrostatic design figure    

%% Definition of the wire structure
%set the potential to +1 and -1 for top and bottom structure. 
U = [1 * ones(1,nInGroup*nGroupsTop), -1 * ones(1,nInGroup*nGroupsBot)];   
xpos = Sx/2 * U; %y coordinates of the wires;
lTop = (nGroupsTop-1)*syGroups + nGroupsTop*(nInGroup-1)*syInGroup;
lBot = (nGroupsBot-1)*syGroups + nGroupsBot*(nInGroup-1)*syInGroup;

%create top structure
i = 1;
ypos(i) = -lTop/2; %make the structure centered on the x-axis
for j = 1:nGroupsTop
    for k = 1:nInGroup
        if j == 1 && k == 1
            continue %we already have a position for this wire
        end
        i = i + 1;
        %use the required separation (between groups or in group)
        if k == 1
            ypos(i) = ypos(i-1) + syGroups;
        else
            ypos(i) = ypos(i-1) + syInGroup;
        end
    end
end

%similar procedure for the bottom structure
i = i+1;
ypos(i) = -lBot/2;
for j = 1:nGroupsBot
    for k = 1:nInGroup
        if j == 1 && k == 1
            continue
        end
        i = i+1;
        if k == 1
            ypos(i) = ypos(i-1) + syGroups;
        else
            ypos(i) = ypos(i-1) + syInGroup;
        end
    end
end
end

