import numpy as np
def load_all(noisy_labels_url, ground_truth_url):
	X = np.loadtxt(noisy_labels_url)
	Y = np.loadtxt(ground_truth_url)
	classes = []
	for c in Y:
		if c not in classes:
			classes.append(c)
	classes.sort()
	a = X.shape
	X = X.tolist()
	for i in range(a[0]):
		for j in range(a[1]):
			if X[i][j] == -1:
				X[i][j] = None
	Y = Y.tolist()
	return X, Y, classes

def loadWeb():
    f = open(r'./data/web/web_train.txt')
    item = []
    worker = []
    label = []
    for line in f:
        data = line.strip().split()
        item.append(int(data[0]))
        worker.append(int(data[1]))
        label.append(int(data[2]))
    cworker = max(worker)
    citem = max(item)
    L = [[None for c in range(cworker)] for x in range(citem)]
    for i in range(len(item)):
        L[item[i]-1][worker[i]-1] = label[i]
    f.close()
    trueLabels = [None for c in range(citem)]
    f = open(r'./data/web/web_gold.txt')
    for line in f:
        data = line.strip().split()
        trueLabels[int(data[0])-1] = int(data[1])
    f.close()
    labelDomain = [1, 2, 3, 4, 5]
    return L, trueLabels, labelDomain

def loadTrec():
    f = open(r'./data/trec/trec_train.txt')
    item = []
    worker = []
    label = []
    for line in f:
        data = line.strip().split()
        item.append(int(data[0]))
        worker.append(int(data[1]))
        label.append(int(data[2]))
    cworker = max(worker)
    citem = max(item)
    L = [[None for c in range(cworker)] for x in range(citem)]
    for i in range(len(item)):
        L[item[i]-1][worker[i]-1] = label[i]
    f.close()
    trueLabels = [None for c in range(citem)]
    f = open(r'./data/trec/trec_gold.txt')
    for line in f:
        data = line.strip().split()
        trueLabels[int(data[0])-1] = int(data[1])
    f.close()
    labelDomain = [1, 2]
    return L, trueLabels, labelDomain



def loadAge():
    f = open(r'./data/age/age_train.txt')
    item = []
    worker = []
    label = []
    for line in f:
        data = line.strip().split()
        item.append(int(data[0]))
        worker.append(int(data[1]))
        label.append(int(data[2]))
    cworker = max(worker)
    citem = max(item)
    L = [[None for c in range(cworker)] for x in range(citem)]
    for i in range(len(item)):
        L[item[i]-1][worker[i]-1] = label[i]
    f.close()
    trueLabels = [None for c in range(citem)]
    f = open(r'./data/age/age_gold.txt')
    for line in f:
        data = line.strip().split()
        trueLabels[int(data[0])-1] = int(data[1])
    f.close()
    labelDomain = [1, 2, 3, 4, 5, 6, 7]
    return L, trueLabels, labelDomain

def loadAdult():
    f = open(r'./data/adult/adult_train.txt')
    item = []
    worker = []
    label = []
    for line in f:
        data = line.strip().split()
        item.append(int(data[0]))
        worker.append(int(data[1]))
        label.append(int(data[2]))
    cworker = max(worker)
    citem = max(item)
    L = [[None for c in range(cworker)] for x in range(citem)]
    for i in range(len(item)):
        L[item[i]-1][worker[i]-1] = label[i]
    f.close()
    trueLabels = [None for c in range(citem)]
    f = open(r'./data/adult/adult_gold.txt')
    for line in f:
        data = line.strip().split()
        trueLabels[int(data[0])-1] = int(data[1])
    f.close()
    labelDomain = [1, 2, 3, 4]
    return L, trueLabels, labelDomain





def loadSyn():
    f = open(r'./data/syn/syn_train.txt')
    item = []
    worker = []
    label = []
    for line in f:
        data = line.strip().split()
        item.append(int(data[0]))
        worker.append(int(data[1]))
        label.append(int(data[2]))
    cworker = max(worker)
    citem = max(item)
    L = [[None for c in range(cworker)] for x in range(citem)]
    for i in range(len(item)):
        L[item[i]-1][worker[i]-1] = label[i]
    f.close()
    trueLabels = [None for c in range(citem)]
    f = open(r'./data/syn/syn_gold.txt')
    for line in f:
        data = line.strip().split()
        trueLabels[int(data[0])-1] = int(data[1])
    f.close()
    labelDomain = [1, 2, 3, 4, 5]
    return L, trueLabels, labelDomain

def loadHeart():
    f = open(r'./data/heartdisease/heart_train.txt')
    item = []
    worker = []
    label = []
    for line in f:
        data = line.strip().split()
        item.append(int(data[0]))
        worker.append(int(data[1]))
        label.append(int(data[2]))
    cworker = max(worker)
    citem = max(item)
    L = [[None for c in range(cworker)] for x in range(citem)]
    for i in range(len(item)):
        L[item[i]-1][worker[i]-1] = label[i]
    f.close()
    trueLabels = [None for c in range(citem)]
    f = open(r'./data/heartdisease/heart_gold.txt')
    for line in f:
        data = line.strip().split()
        trueLabels[int(data[0])-1] = int(data[1])
    f.close()
    labelDomain = [1, 2]
    return L, trueLabels, labelDomain

def loadRte():
    f = open(r'./data/rte/rte_crowd.txt')
    item = []
    worker = []
    label = []
    for line in f:
        data = line.strip().split()
        item.append(int(data[0]))
        worker.append(int(data[1]))
        label.append(int(data[2]))
    cworker = max(worker)
    citem = max(item)
    L = [[None for c in range(cworker)] for x in range(citem)]
    for i in range(len(item)):
        L[item[i]-1][worker[i]-1] = label[i]
    f.close()
    trueLabels = [None for c in range(citem)]
    f = open(r'./data/rte/rte_truth.txt')
    for line in f:
        data = line.strip().split()
        trueLabels[int(data[0])-1] = int(data[1])
    f.close()
    labelDomain = [1, 2]
    return L, trueLabels, labelDomain
