import numpy as np
import keras.backend as K
from keras.callbacks import Callback, LearningRateScheduler


class SGDLearningRateTracker(Callback):
    def __init__(self, model):
        super(SGDLearningRateTracker, self).__init__()
        self.model = model

    def on_epoch_begin(self, epoch, logs={}):
        init_lr = float(K.get_value(self.model.optimizer.lr))
        decay = float(K.get_value(self.model.optimizer.decay))
        iterations = float(K.get_value(self.model.optimizer.iterations))
        lr = init_lr * (1. / (1. + decay * iterations))
        #print('init lr: %.4f, current lr: %.4f, decay: %.4f, iterations: %s' % (init_lr, lr, decay, iterations))