import matplotlib.pyplot as plt
import pickle
def loss_acc_plot(h, epochs_init, epochs_training, ifsaving):
    nb_epoch = epochs_init + epochs_training
    acc, loss, val_acc, val_loss = h.history['acc'], h.history['loss'], h.history['val_acc'], h.history['val_loss']
    plt.figure(figsize=(15, 5))
    plt.subplot(121)
    plt.plot(range(nb_epoch), acc, label='Train')
    plt.plot(range(nb_epoch), val_acc, label='Test')
    plt.title('Accuracy over ' + str(nb_epoch) + ' Epochs', size=15)
    plt.legend(loc='upper left')
    plt.grid(True)
    plt.subplot(122)
    plt.plot(range(nb_epoch), loss, label='Train')
    plt.plot(range(nb_epoch), val_loss, label='Test')
    plt.title('Loss over ' + str(nb_epoch) + ' Epochs', size=15)
    plt.legend(loc='upper left')
    plt.grid(True)
    if ifsaving:
    	plt.savefig('data/figure_epoch_'+str(epochs_init)+'+'+str(epochs_training)+'AL_bvssb.png', format='eps', dpi=1000)
    plt.show()

with open('results30+20_47chunks_0.05oracle-dynamic0.pickle', 'rb') as file_pi:
    h = pickle.load(file_pi)
loss_acc_plot(h,30,940,False)
print(h.history['val_acc'][-1])