# Trusted Loss Correction for Noisy Multi-Label Learning

This supplemental material provides the code used to generate the results in the paper Trusted Loss Correction for Noisy Multi-Label Learning (TLCM).
*train_tlcm.py* provides the implementation of our robust multi-label learning, TLCM, against corrupted labels.

# Pre-trained Models

*MODEL_ZOO.md* provides pre-trained models on various datasets. Before training TLCM, it is necessary to download the pre-trained model(s) corresponding to the dataset(s) of choice. 

# Datasets

To train and test TLCM it is necessary to previously download a dataset.
The datasets used in the paper can be obtained here:

- MIRFLICKR [link](https://press.liacs.nl/mirflickr/)
- MS COCO 2014 [link](https://cocodataset.org/#download)
- NUS-WIDE [link](https://lms.comp.nus.edu.sg/wp-content/uploads/2019/research/nuswide/NUS-WIDE.html)

# Requirements

To install the python requirements run:

```python
pip install -r requirements.txt
```

# Training and Testing TLCM

To train and test TLCM, you need to run *train_tlcm.py*. Command-line arguments allow testing different parameters. 
We provide an example of how to run the code via *run_tlcm.sh*. 
The code trains and evaluates each model in the same run. 


# References

The code is based on:
- https://github.com/Alibaba-MIIL/ASL
