import math
import gurobipy as gp
from gurobipy import GRB,quicksum
import pandas as pd
import numpy_financial as npf
import numpy as np

#Features of the model
#PORT AND CASE ARE NOW SPECIFIED HERE AS WELL AS SEASONALITIES + FACTORS
port='NL33'
month = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
month_factor18=[0.0855,0.0941,0.1052,0.0927,0.0960,0.0985,0.0924,0.0818,0.0773,0.0659,0.0502,0.0604]
month_factor = [0.0783,0.0806,0.0881,0.0831,0.0863,0.0858,0.0909,0.0856,0.0837,0.0832,0.0778,0.0766] #fraction of yearly demand per month
seasonality = month_factor
fix_NUM = 4

#Factors for sensitivity analyses
demand_factor=1
services_factor=1
servTime_factor=1
sailtime_factor=1
waitTime_variation=0
calls_variation=0


IX_moor = 0.25 #sail time between import and export MMT: CHANGED ACCORDING TO NEW ASSUMPTIONS
MT_wait = 1 #waiting time for IWV at MMT
MT_serve = 0.05 #handling time per TEU at MMT
term_wait_shuttle = 0 #should stay 0 : waiting time of MMT shuttles at deep-sea terminals

MT_crane_cap = 124 #crane module capacity (TEUs)
MT_barge_cap = 138 #other module capacity (TEUs)
N_impexp_term = 2
barge_cap = 256
sail_speed = 13

#cost parameters
mainvar_cost_hr = 1.25
Fuelcons_idle_hr = 6.66
fuelcons13sail_km = 8.97
fuelcons5sail_hr = 9.62
cost_fuel_l = 1.0
costvar_shuttle = 0.16
fuel_idlehr_shuttle = 0.75
fuel_cons_shuttle5_hr = 2.47
cost_fixed_shuttle = 53.16
cost_fixed = 86.64


#Mobile terminal handling cost analysis
#cost parameters
life_span = 30
residual_value = 0.30
capital = 5330000
crane_cost = 940000
move_per_hr = 1 / 0.05
ope_hr = 20
max_cap_yr = move_per_hr * ope_hr * 6 * 50
insurance_MT = (0.2/100) * capital
insurance_crane = (2/100) * crane_cost
labour_yr = 60000
tot_overhead_yr = 225000
tot_main_yr = (0.02 * capital) + (0.05 * crane_cost)

if(port == 'NL33'):
    region_list = ['BE22','BE23','BE25','CH03','DE11','DE12','DE13','DE71','DEA1','DEA2','DEB1','DEB3','FRF1','NL22','NL31','NL32','NL34','NL41','NL42']
    dist = [233,175,223,860,736,673,858,529,258,331,434,586,923,145,101,144,172,110,259]
    export_volume = [4104,32802,5519,16798,4648,3021,2136,28348,183850,22469,9367,48850,20464,26145,57630,131231,40181,144269,38364]
    import_volume = [48662,288188,87598,177029,0,13192,2088,22307,402797,37054,9795,172465,17910,54805,35208,84436,33494,115328,43977]
    export_time = [19,14,15,18,23,69,54,69,43,21,27,35,47,74,12,8,12,14,9,21]
    import_time = [19,14,15,18,23,69,54,69,43,21,27,35,47,74,12,8,12,14,9,21]
    freq = [189,800,270,400,16,163,75,160,1563,240,58,562,146,654,312,993,400,3189,1000]
    occupationIWV = [0.55,0.78,0.67,0.95,0.57,0.19,0.11,0.62,0.73,0.48,0.65,0.77,0.51,0.24,0.58,0.42,0.36,0.16,0.16]
    max_NUM = 8 #ASSUMPTION OF MAX NUMBER OF MMTs IN SEAPORT. 
    #This assumption is thesame with that of Antwerp
    N_term = 4 + calls_variation #number of visited terminals by IWV in seaport
    term_wait = 4 + waitTime_variation #waiting time at each deep-sea terminal for IWV
    term_serve = 0.05 * servTime_factor #handling time per TEU at deep-sea terminal
    term_sail = 1 * sailtime_factor #sailing time between each deep-sea terminals
    MT_sail = 1.65 #sail time between MMT and deep-sea port (incl. mooring/unmooring at port and MMT)
    
if(port == 'BE21'):
    region_list = ['BE22','BE23','BE24','BE25','BE33','CH03','DE11','DE12','DE13','DE71','DEA1','DEA2','DEB1','DEB2','DEB3','FRF1','NL22','NL31','NL32','NL41','NL42']
    dist = [91,87,42,128,138,885,761,698,883,554,283,356,459,559,611,948,170,182,225,122,164]
    export_volume = [18638,24353,14448,102007,46247,25808,7390,34258,7483,7743,163721,30901,44069,9639,97953,79406,12398,232,205043,121367,77476]
    import_volume = [6850,12385,3401,163011,12685,27875,4345,15654,1491,6038,56223,12103,9689,657,69422,22994,9579,27573,278516,83951,32576]
    export_time = [7,7,3,10,11,71,61,56,71,45,23,29,37,45,49,76,14,15,18,5,10]
    import_time = [7,7,3,10,11,71,61,56,71,45,23,29,37,45,49,76,14,15,18,5,10]
    freq = [275,400,300,600,250,180,175,141,101,203,870,241,184,150,618,252,400,98,993,444,450]
    occupationIWV = [0.18,0.18,0.12,0.86,0.46,0.58,0.13,0.69,0.17,0.13,0.49,0.35,0.57,0.13,0.53,0.79,0.11,0.55,0.95,0.90,0.48]
    max_NUM = 8 #ASSUMPTION OF MAX NUMBER OF MMTs IN SEAPORT
    N_term = 4 + calls_variation #number of visited terminals by IWV in seaport
    term_wait = 4 + waitTime_variation #waiting time at each deep-sea terminal for IWV
    term_serve = 0.05 * servTime_factor #handling time per TEU at deep-sea terminal
    term_sail = 1 * sailtime_factor #sailing time between each deep-sea terminals
    MT_sail = 1.05 #sail time between MMT and deep-sea port (incl. mooring/unmooring at port and MMT)
    
    
I = range(N_term)
R = range(len(region_list))

M=999999 #Big number for cosntraint consistency

export_volume_year = [demand_factor*element for element in export_volume]
import_volume_year = [demand_factor*element for element in import_volume]
freq_year = [round(services_factor*element) for element in freq]


export_volume_year_i=[[round(element/N_term) for element in export_volume_year]]*N_term
import_volume_year_i=[[round(element/N_term) for element in import_volume_year]]*N_term
term_wait_i=[term_wait]*N_term
term_serve_i=[term_serve]*N_term

nMonths = len(seasonality)
T=range(nMonths)

freq_month = [[round(element/nMonths) for element in freq_year]]*nMonths
freq_year = [sum([row[i] for row in freq_month]) for i in range(0,len(freq_month[0]))]

export_volume_month_i = [[[] for i in I] for t in T]
import_volume_month_i = [[[] for i in I] for t in T]
for t in T:
    for i in I:
            export_volume_month_i[t][i]=[round(seasonality[t]*element) for element in export_volume_year_i[i]]
            import_volume_month_i[t][i]=[round(seasonality[t]*element) for element in import_volume_year_i[i]]

term_wait_month_i=[term_wait_i]*nMonths
term_serve_month_i=[term_serve_i]*nMonths

    
t_rt_hinter = lambda r,t : freq_month[t][r]*(export_time[r]+import_time[r])
t_rt_sail = lambda r,t : freq_month[t][r]*term_sail*N_term
t_rt_wait = lambda r,t : freq_month[t][r]*sum(term_wait_month_i[t][i] for i in I)
t_rt_serve = lambda r,t : sum(term_serve_month_i[t][i]*(export_volume_month_i[t][i][r]+import_volume_month_i[t][i][r]) for i in I)

sequence = ["sail","wait","serv"]

T_hinterl = sum(t_rt_hinter(r,t) for r in R for t in T)
T_port = [sum(t_rt_sail(r,t) for r in R for t in T), sum(t_rt_wait(r,t) for r in R for t in T), sum(t_rt_serve(r,t) for r in R for t in T)]

barges_port = sum(math.ceil(freq_year[r]) for r in R)

print("BASE CASE")
print("Time in hinterland: %d" % T_hinterl)
for k in range(len(T_port)):
    print("Time " + sequence[k] + "ing in port: %d" % T_port[k])
print("Total time: %d" % (T_hinterl+sum(T_port)))
print("")
print("Barges in port per year: %d" % barges_port)
print("--------------------------------------")

BENCHMARK = T_hinterl+sum(T_port)

n = gp.Model("MT_model")

x_import = []
x_export = []
for t in T:
    x_import.append(n.addVar(lb = 0, vtype = GRB.INTEGER, name = 'x_import('+str(t)+')'))
    x_export.append(n.addVar(lb = 0, vtype = GRB.INTEGER, name = 'x_export('+str(t)+')'))
y = []
z = []
for t in T:
    y.append([])
    z.append([])
    for r in R:
        y[t].append(n.addVar(vtype = GRB.BINARY, name = 'y['+str(t)+']['+str(r)+']'))
    for i in I:
        z[t].append(n.addVar(lb = 0, vtype = GRB.INTEGER, name = 'z['+str(t)+']['+str(i)+']'))

T_hinter = []
T_port_sail = []
T_portH_wait = []
T_portM_wait = []
T_port_serve = []
T_MT_sail = []
T_MT_wait = []
T_MT_serve = []
    
for t in T:    
    T_hinter.append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'T_hinter('+str(t)+')'))
    T_port_sail.append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'T_port_sail('+str(t)+')'))
    T_portH_wait.append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'T_portH_wait('+str(t)+')'))
    T_portM_wait.append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'T_portM_wait('+str(t)+')'))
    T_port_serve.append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'T_port_serve('+str(t)+')'))
    T_MT_sail.append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'T_MT_sail('+str(t)+')'))
    T_MT_wait.append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'T_MT_wait('+str(t)+')'))
    T_MT_serve.append(n.addVar(lb = 0, vtype = GRB.CONTINUOUS, name = 'T_MT_serve('+str(t)+')'))
n.update()    

for t in T:
    n.addConstr(T_hinter[t] == quicksum(t_rt_hinter(r,t) for r in R))
    n.addConstr(T_port_sail[t] == quicksum(N_term*term_sail*freq_month[t][r]*(1-y[t][r]) for r in R))
    n.addConstr(T_portH_wait[t] == quicksum(term_wait_month_i[t][i]*quicksum(freq_month[t][r]*(1-y[t][r]) for r in R) for i in I))
    n.addConstr(T_portM_wait[t] == quicksum(term_wait_shuttle*z[t][i] for i in I))
    n.addConstr(T_port_serve[t] == quicksum(t_rt_serve(r,t) for r in R))
    n.addConstr(T_MT_sail[t] == (2*MT_sail+IX_moor)*quicksum(z[t][i] for i in I) + quicksum(freq_month[t][r]*(y[t][r]*IX_moor) for r in R))
    n.addConstr(T_MT_wait[t] == quicksum(2*MT_wait*y[t][r]*freq_month[t][r] for r in R))
    n.addConstr(T_MT_serve[t] == quicksum(MT_serve*y[t][r]*(export_volume_month_i[t][i][r]+import_volume_month_i[t][i][r]) for i in I for r in R))

n.setObjective(quicksum((T_hinter[t] + T_port_sail[t] + T_portH_wait[t] + T_portM_wait[t] + T_port_serve[t] + T_MT_sail[t] + T_MT_wait[t] + T_MT_serve[t]) for t in T))
n.modelSense = GRB.MINIMIZE
n.update()

for t in T:
    n.addConstr(quicksum(y[t][r]*import_volume_month_i[t][i][r] for r in R for i in I)*MT_serve<=480*x_import[t])
    n.addConstr(quicksum(y[t][r]*export_volume_month_i[t][i][r] for r in R for i in I)*MT_serve<=480*x_export[t])

for t in T:
    n.addConstr(quicksum(z[t][i] for i in I)/30/2 <= x_import[t])
    n.addConstr(quicksum(z[t][i] for i in I)/30/2 + 1 >= x_import[t])
    n.addConstr(quicksum(z[t][i] for i in I)/30/2 <= x_export[t])
    n.addConstr(quicksum(z[t][i] for i in I)/30/2 + 1 >= x_export[t])
    n.addConstr((x_import[t]+x_export[t]) <= max_NUM)
    n.addConstr(x_import[t] == fix_NUM/2)
    n.addConstr(x_export[t] == fix_NUM/2)
    for i in I:
        n.addConstr(z[t][i]<=quicksum(y[t][r] for r in R)*M)
        n.addConstr(quicksum(y[t][r]*import_volume_month_i[t][i][r] for r in R) <= z[t][i]*MT_barge_cap)
        n.addConstr(quicksum(y[t][r]*export_volume_month_i[t][i][r] for r in R) <= z[t][i]*MT_barge_cap) 
    
n.update()

n.write('MMTCase.lp')
n.setParam('OutputFlag', False)
n.optimize()

barges_port = math.ceil((sum((1-y[t][r].x)*freq_month[t][r] for r in R for t in T)+sum(z[t][i].x for i in I for t in T))/50)

importMT_time = []
exportMT_time = []

for t in T:
    if x_import[t].x>0:
        importMT_time.append(sum(y[t][r].x*import_volume_month_i[t][i][r] for r in R for i in I)*MT_serve/x_import[t].x)
    if x_export[t].x>0:
        exportMT_time.append(sum(y[t][r].x*export_volume_month_i[t][i][r] for r in R for i in I)*MT_serve/x_export[t].x)


#################### FORMATTED OUTPUTS FOR COST MODEL #####################
 
monthly_rate_uti=[]
for t in T:
    total_volume = 0
    for r in R:
        if y[t][r].x == 1:
            for i in I:
                total_volume += (import_volume_month_i[t][i][r] + export_volume_month_i[t][i][r])
    monthly_rate_uti.append(total_volume /(x_import[t].x + x_export[t].x)/(max_cap_yr/12)) 

rate_uti = sum(monthly_rate_uti) / 12
actual_uti = max_cap_yr * rate_uti
cranehr_yr = actual_uti/move_per_hr
fuel_teu = (36 * cranehr_yr) / actual_uti
opr_cost = 624460
WACC = 0.06
Max_TEUcost = 41.01 #deepsea terminal handling cost from cornelies model
MT_hand_cap = actual_uti  # Actual utilization of the MT based on the occupation rate
year = 30
interest = 0.045
tot_cap = capital + crane_cost
index = 0.014
residual_value = 0.30
tax = 0.33

tot_capcost_yr = npf.pmt(WACC,life_span,-capital,capital*residual_value,0) + npf.pmt(WACC,life_span,-crane_cost,crane_cost*residual_value,0)
tot_fixoper_yr = insurance_MT + insurance_crane + labour_yr + tot_overhead_yr + tot_main_yr
cost_TEU = (tot_capcost_yr + tot_fixoper_yr) / actual_uti + (fuel_teu * cost_fuel_l) # mobile terminal handling cost without markup margin

#investment analysis
while cost_TEU < Max_TEUcost:
    loan_payment = npf.pmt(interest, year, -tot_cap)
    inv_table = np.zeros((year, 9))
    inv_table = pd.DataFrame(inv_table)
    pd.options.display.float_format = '{:,.0f}'.format
    inv_table.columns = ['Year', 'Initial_Balance', 'Payments', 'Interest', 'Principal', 'Ending_Balance', 'Depreciation', 'operating_cost', 'Revenues']
    inv_table.iloc[0,0] = 1
    inv_table.iloc[0,1] = tot_cap
    inv_table.iloc[0,2] = loan_payment
    inv_table.iloc[0,3] = tot_cap * interest
    inv_table.iloc[0,4] = loan_payment - (tot_cap * interest)
    inv_table.iloc[0,5] = tot_cap - (loan_payment - (tot_cap * interest))
    inv_table.iloc[0,6] = tot_cap / year
    inv_table.iloc[0,7] = opr_cost
    inv_table.iloc[0,8] = cost_TEU * MT_hand_cap
    for i in range (1,30):
        inv_table.iloc[i,0] = i + 1
        inv_table.iloc[i,1] = inv_table.iloc[(i-1), 5]
        inv_table.iloc[i,2] = loan_payment
        inv_table.iloc[i,3] = inv_table.iloc[i,1] * interest
        inv_table.iloc[i,4] = loan_payment - (inv_table.iloc[i,1] * interest)
        inv_table.iloc[i,5] = inv_table.iloc[i,1] - (loan_payment - (inv_table.iloc[i,1] * interest))
        inv_table.iloc[i,6] = tot_cap / year
        inv_table.iloc[i,7] = inv_table.iloc[(i - 1) ,7] * (1 + index)
        inv_table.iloc[i,8] = inv_table.iloc[(i - 1) ,8] * (1 + index)
    inv_table['terminal_value'] = np.where(inv_table['Year'] == year, (tot_cap * residual_value), 0)
    inv_table['financial_cost'] = inv_table['Payments'] + inv_table['Interest']
    inv_table['EBITDA'] = inv_table['Revenues'] + inv_table['terminal_value'] - inv_table['operating_cost']
    inv_table['opr_result'] = inv_table['EBITDA'] - inv_table['Depreciation']
    inv_table['EBT'] = inv_table['opr_result'] - inv_table['Interest']
    inv_table['Tax'] = np.where(inv_table['EBT'] > 0, (tax * inv_table['EBT']) , 0)
    inv_table['EAT'] = inv_table['EBT'] - inv_table['Tax']
    inv_table['cash_flow'] = inv_table['EAT'] + inv_table['Depreciation'] - inv_table['Payments']
    cashflows = inv_table['cash_flow'].values.tolist()
    cashflows.insert(0, -tot_cap)
    NPV = round(npf.npv(WACC, cashflows))
    IRR = round(npf.irr( cashflows), 2)
    if NPV > 0:
        break
    cost_TEU *= 1.1  
print('MOBILE TERMINAL BENEFIT')
print('-----------------------')
print('Optimal handling cost at the mobile terminal is: {}'.format(round(cost_TEU)))
print('NPV of mobile terminal operator is: {}'.format(NPV))
print('IRR of mobile terminal operator is: {}'.format(IRR))
###-------END OF INVESTMENT ANALYSIS-----###
# Preparation of outputs
sum_vol = []
for r in R:
    sum_vol.append(export_volume[r]+import_volume[r])
num_MMT = []
num_shuttles = []
occ_rate = []
map_excl_regions = {}
for t in T:
    num_MMT.append(x_import[t].x + x_export[t].x)
    num_shuttles.append(z[t][0].x)
    occ_rate.append((sum(y[t][r].x*(import_volume_month_i[t][i][r]) for r in R for i in I)/sum(z[t][i].x*MT_barge_cap for i in I)+sum(y[t][r].x*(export_volume_month_i[t][i][r]) for r in R for i in I)/sum(z[t][i].x*MT_barge_cap for i in I))/2)
    reg_month=()
    for r in R:
        if y[t][r].x == 0:
            reg_month = reg_month + (int(r),)
    map_excl_regions[month[t]]=reg_month
# The outputs you need (region_list and dist are already defined at the beginning of the code):    
tot_vol=sum_vol
service=freq
N_MT=num_MMT
shuttle_MT=num_shuttles
occ_rate_MT=occ_rate
mapping=map_excl_regions

def calc_rate(t, s, seasonality):
    return (t * seasonality) / (s/12) / barge_cap / 2
def exclude_months(*args):
    vol = [x for i, x in enumerate(tot_vol) if i not in args]
    serv = [x for i, x in enumerate(service) if i not in args]
    reg = [x for i, x in enumerate(region_list) if i not in args]
    km = [x for i, x in enumerate(dist) if i not in args]
    sail = [x for i, x in enumerate(import_time) if i not in args]
    return vol, serv, reg, km, sail

regions = {}
for (month, exclude) in mapping.items():
    regions[month] = [
        r for r in exclude_months(*exclude)[2]
    ]
occ_rate = {}
for (month, exclude), season in zip(mapping.items(), seasonality):
    occ_rate[month] = [
        calc_rate(t, s, season) for t, s in zip(exclude_months(*exclude)[0], exclude_months(*exclude)[1])
    ]
distance = {}
for (month, exclude) in mapping.items():
    distance[month] = [
        r for r in exclude_months(*exclude)[3]
    ]
sail_time = {}
for (month, exclude) in mapping.items():
    sail_time[month] = [
        r for r in exclude_months(*exclude)[4]
    ]
barge_cap_trans = {month: [barge_cap * r for r in rate]
                  for month, rate in occ_rate.items()}

#sailing to deepsea terminal
time_port_DT = {month: [(term_wait*N_term) + (c * term_serve) + (term_sail*N_term) for c in cap]
                for month, cap in barge_cap_trans.items()}

time_idle_DT = {month: [0.1 * (s+p) for (s, p) in zip(sail, port)]
               for (month, sail), (month, port) in zip(sail_time.items(), time_port_DT.items())}

time_total_DT = {month: [(s+p+i) for (s, p, i) in zip(sail, port, idle)]
                for (month, sail), (month, port), (month, idle) in zip(sail_time.items(), time_port_DT.items(),time_idle_DT.items())}
hr_saileng_DT = {month: [(term_sail*N_term) + t for t in time]
                for month, time in sail_time.items()}
hr_totaleng_DT = {month: [(i + s) for (i, s) in zip(idle, sail)]
                 for (month, idle), (month, sail) in zip(time_idle_DT.items(), hr_saileng_DT.items())}
fuel_sailtrp_DT = {month: [fuelcons13sail_km * k for k in km]
                  for month, km in distance.items()}
fuel_idletrp_DT = {month: [Fuelcons_idle_hr * h for h in hr]
                  for month, hr in time_idle_DT.items()}
fuel_sailterm_DT = term_sail*N_term*fuelcons5sail_hr
total_fueltrip_DT = {month: [fuel_sailterm_DT + (s + i) for (s, i) in zip(sail, idle)]
                    for (month, sail), (month, idle) in zip(fuel_sailtrp_DT.items(), fuel_idletrp_DT.items())}
costvar_trip_DT = {month: [mainvar_cost_hr * h for h in hr]
                  for month, hr in hr_totaleng_DT.items()}
costfuel_trip_DT = {month: [cost_fuel_l * l for l in lt]
                   for month, lt in total_fueltrip_DT.items()}
costfix_trip_DT = {month: [cost_fixed * h for h in hr]
                  for month, hr in time_total_DT.items()}
costtot_trip_DT = {month: [(v+l+f) for (v, l, f) in zip(var, lt, fix)]
                  for (month, var), (month, lt), (month, fix) in zip(costvar_trip_DT.items(), costfuel_trip_DT.items(), costfix_trip_DT.items())}
cost_teu_DT = {month: [(c/r) for (c, r) in zip(cost, rate)]
              for (month, cost), (month, rate) in zip(costtot_trip_DT.items(), barge_cap_trans.items())}

#Sailing to mobile terminal
time_port_MT = {month: [(term_wait*N_impexp_term) + (c * MT_serve) + IX_moor for c in cap]
               for month, cap in barge_cap_trans.items()}
time_idle_MT = {month: [0.1 * (s+p) for (s, p) in zip(sail, port)]
               for (month, sail), (month, port) in zip(sail_time.items(), time_port_MT.items())}
time_total_MT = {month: [(s+p+i) for (s, p, i) in zip(sail, port, idle)]
                for (month, sail), (month, port), (month, idle) in zip(sail_time.items(), time_port_MT.items(), time_idle_MT.items())}
hr_saileng_MT = {month: time for month, time in sail_time.items()}
hr_totaleng_MT = {month: [(i + s) for (i, s) in zip(idle, sail)]
                  for (month, idle), (month, sail) in zip(time_idle_MT.items(), hr_saileng_MT.items())}
fuel_sailtrp_MT = {month: [fuelcons13sail_km * k for k in km]
                  for month, km in distance.items()}
fuel_idletrp_MT = {month: [Fuelcons_idle_hr * h for h in hr]
                  for month, hr in time_idle_MT.items()}
total_fueltrip_MT = {month: [(s + i) for (s, i) in zip(sail, idle)]
                    for (month, sail), (month, idle) in zip(fuel_sailtrp_MT.items(), fuel_idletrp_MT.items())}
costvar_trip_MT = {month: [mainvar_cost_hr * h for h in hr]
                  for month, hr in hr_totaleng_MT.items()}
costfuel_trip_MT = {month: [cost_fuel_l * l for l in lt]
                   for month, lt in total_fueltrip_MT.items()}
costfix_trip_MT = {month: [cost_fixed * h for h in hr]
                  for month, hr in time_total_MT.items()}
costtot_trip_MT = {month: [(v+l+f) for (v, l, f) in zip(var, lt, fix)]
                  for (month, var), (month, lt), (month, fix) in zip(costvar_trip_MT.items(), costfuel_trip_MT.items(), costfix_trip_MT.items())}
cost_teu_MT = {month: [(c/r) for (c, r) in zip(cost, rate)]
              for (month, cost), (month, rate) in zip(costtot_trip_MT.items(), barge_cap_trans.items())}

 # From mobile terminal to deepsea terminal
time_sail_shuttle = MT_sail * 2 + IX_moor
time_port_shuttle = [term_wait_shuttle + (MT_barge_cap * r * term_serve) for r in occ_rate_MT]
time_idle_shuttle = [0.1 * (time_sail_shuttle + t) for t in time_port_shuttle]
time_total_shuttle = [time_sail_shuttle + p + i for (p, i) in zip(time_port_shuttle, time_idle_shuttle)]
costvar_trip_shuttle = [costvar_shuttle * (time_sail_shuttle + t) for t in time_idle_shuttle]
costfuel_trip_shuttle = [((time_sail_shuttle * fuel_cons_shuttle5_hr) + (t * fuel_idlehr_shuttle)) * cost_fuel_l for t in time_idle_shuttle]
costfix_trip_shuttle = [(t * cost_fixed_shuttle) for t in time_total_shuttle]
costtot_trip_shuttle = [(v+l+f) for (v, l, f) in zip(costvar_trip_shuttle, costfuel_trip_shuttle, costfix_trip_shuttle)]

cost_teu_shuttle = [c /(MT_barge_cap * r) for (c, r) in zip(costtot_trip_shuttle, occ_rate_MT)]

#Net benefit calculations for barges and shippers
netben_barge = {month :
                {r: (d - m - cost_TEU) for r, d, m in zip(regions[month], cost_teu_DT[month], cost_teu_MT[month])}
                for month in regions.keys()}

def calc_cost(cost_teu_shuttle):
    return [cost_TEU + c for c in cost_teu_shuttle]

months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

dict_shuttle = dict(zip(months, calc_cost(cost_teu_shuttle)))

netben_shippers = {}
for k, v in dict_shuttle.items():
    netben_shippers[k] = {r: (d - m) - v for (r, d, m) in zip(regions[k], cost_teu_DT[k], cost_teu_MT[k])}
    
occ_rate_regions = {}
for k, v in occ_rate.items():
    occ_rate_regions[k] = {r: c for (r,c) in zip(regions[k], occ_rate[k])}
  
    
def calc_volume(t, seasonality):
    return t * seasonality

monthly_volume = {}
for (month, exclude), season in zip(mapping.items(), seasonality):
    monthly_volume[month] = [
        calc_volume(t, season) for t in exclude_months(*exclude)[0]
    ]

monthly_volume_regions = {}
for k, v in monthly_volume.items():
    monthly_volume_regions[k] = {r: c for (r,c) in zip(regions[k], monthly_volume[k])}
    
    
if seasonality == month_factor:
    bargedyna = pd.concat({k: pd.DataFrame.from_dict(v, 'index') for k, v in netben_barge.items()}, axis = 1)
    bargedyna.to_excel(str(fix_NUM)+'MMT'+port+'bargedynamic.xlsx')
    monthlyvola = pd.concat({k: pd.DataFrame.from_dict(v, 'index') for k, v in monthly_volume_regions.items()}, axis = 1)
    monthlyvola.to_excel(str(fix_NUM)+'MMT'+port+'monthlyvolumes.xlsx')
    shipperdyna = pd.concat({k: pd.DataFrame.from_dict(v, 'index') for k, v in netben_shippers.items()}, axis = 1)
    shipperdyna.to_excel(str(fix_NUM)+'MMT'+port+'shipperdynamic.xlsx')
    occrateNORM = pd.concat({k: pd.DataFrame.from_dict(v, 'index') for k, v in occ_rate_regions.items()}, axis = 1)
    occrateNORM.to_excel(str(fix_NUM)+'MMT'+port+'OccRatedynamic.xlsx')
elif seasonality == month_factor18:
    bargedyna18 = pd.concat({k: pd.DataFrame.from_dict(v, 'index') for k, v in netben_barge.items()}, axis = 1)
    bargedyna18.to_excel(str(fix_NUM)+'MMT'+port+'bargedynamic18.xlsx')
    monthlyvola18 = pd.concat({k: pd.DataFrame.from_dict(v, 'index') for k, v in monthly_volume_regions.items()}, axis = 1)
    monthlyvola18.to_excel(str(fix_NUM)+'MMT'+port+'monthlyvolumes18.xlsx')
    shipperdyna18 = pd.concat({k: pd.DataFrame.from_dict(v, 'index') for k, v in netben_shippers.items()}, axis = 1)
    shipperdyna18.to_excel(str(fix_NUM)+'MMT'+port+'shipperdynamic18.xlsx')
    occrate18 = pd.concat({k: pd.DataFrame.from_dict(v, 'index') for k, v in occ_rate_regions.items()}, axis = 1)
    occrate18.to_excel(str(fix_NUM)+'MMT'+port+'OccRatedynamic18.xlsx')

print('BARGE NET BENEFIT')
print('-----------------------')
for k, v in netben_barge.items():
    print(k)
    for r in v:
        if v[r] >= 1:
            print("Barge net benefit between region {} and {}: {}".format(port, r, round(v[r])))
print('')

print('')
print('SHIPPERS NET BENEFIT')
print('-----------------------')
for k, v in netben_shippers.items():
    print(k)
    for r in v:
        if v[r] >= 1:
            print("Shippers net benefit between region {} and {}: {}".format(port, r, round(v[r])))
print('')
    
# ################## WRITE IN EXCEL FILE ####################################
#
vesselsport = []
n_import = []
n_export = []
time_hinter = []
time_port_sail = []
time_port_waitH = []
time_port_waitS = []
time_port_serve = []
time_MT_sail = []
time_MT_waitH = []
time_MT_serve = []
use_IMPORT_shuttle = []
use_EXPORT_shuttle = []
ysol = []
zsol = []
for t in T:
    vesselsport.append(sum((1-y[t][r].x)*freq_month[t][r] for r in R) +sum(z[t][i].x for i in I))
    n_import.append(x_import[t].x)
    n_export.append(x_export[t].x)
    time_hinter.append(T_hinter[t].x)
    time_port_sail.append(T_port_sail[t].x)
    time_port_waitH.append(T_portH_wait[t].x)
    time_port_waitS.append(T_portM_wait[t].x)
    time_port_serve.append(T_port_serve[t].x)
    time_MT_sail.append(T_MT_sail[t].x)
    time_MT_waitH.append(T_MT_wait[t].x)
    time_MT_serve.append(T_MT_serve[t].x)
    use_IMPORT_shuttle.append(sum(y[t][r].x*(import_volume_month_i[t][i][r]) for r in R for i in I)/sum(z[t][i].x*MT_barge_cap for i in I))
    use_EXPORT_shuttle.append(sum(y[t][r].x*(export_volume_month_i[t][i][r]) for r in R for i in I)/sum(z[t][i].x*MT_barge_cap for i in I))
    zsol1=[]
    ysol1=[]
    for i in I:
        zsol1.append(z[t][i].x)
    for r in R:
        ysol1.append(y[t][r].x)
    zsol.append(zsol1)
    ysol.append(ysol1)

results_dyna = pd.DataFrame(list(zip(n_import,n_export,vesselsport,importMT_time,exportMT_time,time_hinter,time_port_sail,time_port_waitH,time_port_waitS,time_port_serve,time_MT_sail,time_MT_waitH,time_MT_serve,use_IMPORT_shuttle,use_EXPORT_shuttle,monthly_rate_uti)),columns =['Number_importMT','Number_exportMT','MonthlyBargesInPort','MonthlyHandtime_importMT','Monthly_handtime_exportMT','T_hinter','T_port_sail','T_portH_wait','T_portM_wait','T_port_serve','T_MT_sail','T_MT_wait','T_MT_serve','Occ_import_shuttle','Occ_export_shuttle','Occ_rate_MMTs'])
Ysol = pd.DataFrame(ysol, columns=region_list)
Zsol = pd.DataFrame(zsol)

results_dyna.to_csv(str(fix_NUM)+'MMT'+port+'solutionYEAR.csv', sep=';')
Ysol.to_csv(str(fix_NUM)+'MMT'+port+'linkedRegionsYEAR.csv', sep=';')
Zsol.to_csv(str(fix_NUM)+'MMT'+port+'shuttleFreqYEAR.csv', sep=';')


# In[ ]:




