import itertools
import numpy as np
import gurobipy as gp
from gurobipy import GRB,quicksum
import math
import pandas as pd
import scipy.stats as sps
import sys
from shipper import Shipment, Shipper, Population
from utility import Utility, ODpair
from network import Network, Services
from fleet import Vessel, Fleet

from iwtoperator import IWToperator
from postprocess import writeExcelFile

ucase = "D-D" #"D-C" "C-D" "C-C"

fleetsize1 = [24,18]
fleetsize2 = [24,18]

boundp = 10000
boundf = 10000

demand_factor=1

method = "Exact"
utype = 'Deter'
instancename = utype+'_'+method+'_9n_'

terminals=["RTM", "NIJ", "DUI", "BON", "AND", "MAI", "LUH", "SXB", "BSL"]

otheriwtprices=[[0, 54, 68, 76, 89, 100, 107, 140, 141],
        [61, 0, 50, 59, 72, 83, 90, 123, 124],
        [69, 45, 0, 46, 58, 70, 76, 109, 110],
        [74, 50, 46, 0, 49, 60, 67, 100, 101],
        [82, 58, 56, 49, 0, 48, 55, 88, 89],
        [89, 72, 70, 60, 48, 0, 43, 76, 77],
        [93, 79, 76, 67, 55, 43, 0, 69, 70],
        [112, 118, 109, 100, 88, 76, 69, 0, 37],
        [113, 119, 110, 101, 89, 77, 70, 37, 0]]

otheriwtfreqs=[[0, 4, 22, 4, 1, 3, 1, 3, 4],
        [4, 0, 1, 0, 0, 0, 0, 0, 1],
        [19, 1, 0, 6, 1, 0, 1, 0, 0],
        [6, 0, 5, 0, 5, 4, 0, 0, 0],
        [1, 0, 0, 5, 0, 4, 0, 0, 0],
        [3, 1, 0, 4, 4, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 1, 0, 0, 1],
        [2, 0, 0, 0, 0, 0, 0, 0, 7],
        [3, 1, 1, 0, 0, 0, 0, 7, 0]]

Ocosts = [[[0, 1600, 2200, 2700, 3300, 3900, 4200, 5700, 5800],
           [4200, 0, 1400, 1800, 2400, 3000, 3300, 4900, 5000],
           [4700, 1300, 0, 1100, 1800, 2300, 2700, 4400, 4300],
           [5100, 1600, 1100, 0, 1300, 1900, 2200, 3800, 3900],
           [5600, 2100, 1800, 1300, 0, 1300, 1600, 3100, 3200],
           [6100, 2600, 2300, 1900, 1300, 0, 1000, 2600, 2700],
           [6400, 2900, 2700, 2200, 1600, 1000, 0, 2200, 2300],
           [7600, 4200, 4100, 3800, 3100, 2600, 2200, 0, 700],
           [7700, 4300, 4200, 3900, 3200, 2700, 2300, 700, 0]],
          [[0, 2600, 3600, 4200, 5100, 5900, 6400, 8700, 8800],
           [5300, 0, 2300, 3000, 3900, 4700, 5200, 7500, 7600],
           [6100, 2100, 0, 2000, 2900, 3700, 4200, 6500, 6600],
           [6600, 2600, 2000, 0, 2200, 3100, 3600, 5900, 6000],
           [7300, 3300, 2900, 2200, 0, 2200, 2700, 5000, 5100],
           [8000, 4000, 3700, 3100, 2200, 0, 1800, 4100, 4200],
           [8400, 4400, 4200, 3600, 2700, 1800, 0, 3600, 3700],
           [10100, 6500, 6100, 5900, 5000, 4100, 3600, 0, 1300],
           [10200, 6600, 6200, 6000, 5100, 4200, 3700, 1300,0]]]

Vcosts = [[[0, 14, 24, 31, 40, 49, 54, 78, 79],
           [11, 0, 11, 18, 27, 36, 41, 65, 66],
           [13, 6, 0, 8, 17, 26, 31, 55, 56],
           [18, 10, 8, 0, 10, 19, 24, 48, 49],
           [22, 17, 15, 10, 0, 9, 15, 39, 40],
           [27, 26, 23, 19, 9, 0, 6, 30, 31],
           [31, 29, 24, 22, 15, 6, 0, 25, 26],
           [68, 64, 55, 48, 39, 30, 25, 0, 8],
           [70, 66, 56, 49, 40, 31, 26, 8, 0]],
          [[0, 12, 21, 27, 35, 43, 47, 68, 69],
           [6, 0, 10, 15, 24, 31, 36, 57, 58],
           [10, 4, 0, 6, 15, 22, 27, 48, 49],
           [12, 7, 6, 0, 9, 16, 21, 42, 43],
           [16, 15, 11, 9, 0, 8, 13, 34, 35],
           [19, 17, 16, 14, 8, 0, 5, 26, 27],
           [21, 19, 17, 16, 13, 5, 0, 21, 22],
           [61, 57, 48, 42, 34, 26, 21, 0, 7],
           [62, 58, 49, 43, 35, 27, 22, 7, 0]]]

Tsailod = [[[0, 9, 15, 19, 26, 31, 35, 50, 51],
            [8, 0, 6, 11, 17, 22, 27, 42, 43],
            [13, 5, 0, 4, 11, 16, 19, 35, 36],
            [16, 10, 4, 0, 6, 12, 15, 30, 31],
            [22, 14, 11, 6, 0, 5, 9, 25, 26],
            [26, 19, 16, 12, 5, 0, 3, 18, 19],
            [29, 22, 19, 15, 9, 3, 0, 15, 16],
            [41, 35, 33, 30, 25, 18, 15, 0, 4],
            [42, 36, 34, 31, 26, 19, 16, 4, 0]],
           [[0, 11, 19, 25, 33, 40, 44, 63, 64],
            [9, 0, 8, 14, 22, 29, 34, 53, 54],
            [15, 6, 0, 5, 14, 21, 25, 44, 45],
            [19, 11, 5, 0, 7, 15, 19, 39, 40],
            [26, 17, 14, 7, 0, 7, 12, 31, 32],
            [31, 22, 21, 15, 7, 0, 4, 24, 25],
            [35, 27, 25, 29, 12, 4, 0, 20, 21],
            [50, 43, 42, 39, 31, 24, 20, 0, 5],
            [51, 44, 43, 40, 32, 25, 21, 5,0]]] 

OD_matrix_allM = [[0, 5700, 6500, 1900, 100, 600, 3500, 400, 800],
                  [4900, 0, 50, 50, 0, 100, 50, 0, 0],
                  [8400, 100, 0, 6700, 900, 300, 50, 0, 100],
                  [1500, 50, 6500, 0, 2000, 500, 50, 0, 100],
                  [200, 50, 900, 2200, 0, 2100, 0, 50, 50],
                  [600, 50, 100, 400, 1500, 0, 0, 200, 50],
                  [3100, 50, 200, 0, 0, 0, 0, 0, 50],
                  [500, 0, 0, 0, 50, 200, 0, 0, 200],
                  [1200, 50, 50, 50, 50, 50, 0, 100, 0]]

costsROAD = [[0, 171, 252, 317, 439, 566, 584, 1001, 1075],
        [171, 0, 175, 247, 367, 444, 511, 924, 1006],
        [251, 174, 0, 136, 240, 333, 390, 657, 901],
        [315, 246, 136, 0, 159, 278, 294, 571, 652],
        [436, 365, 240, 159, 0, 183, 183, 454, 535],
        [563, 442, 333, 278, 183, 0, 182, 388, 468],
        [581, 509, 390, 294, 183, 182, 0, 371, 452],
        [997, 920, 657, 571, 454, 388, 371, 0, 167],
        [1103, 1032, 927, 675, 553, 484, 467, 172, 0]]

VOTcostROAD = [[0, 3, 4, 5, 6, 8, 9, 12, 14],
        [3, 0, 3, 4, 5, 6, 7, 11, 13],
        [4, 3, 0, 2, 3, 5, 6, 10, 11],
        [5, 4, 2, 0, 2, 4, 5, 8, 10],
        [6, 5, 3, 2, 0, 3, 4, 6, 8],
        [8, 6, 5, 4, 3, 0, 3, 5, 7],
        [8, 7, 6, 4, 3, 2, 0, 5, 6],
        [12, 11, 10, 8, 6, 5, 4, 0, 3],
        [14, 13, 11, 10, 8, 7, 6, 3, 0]]

accROAD = [[0, 37, 45, 42, 23, 35, 32, 23, 28],
        [37, 0, 48, 45, 26, 38, 35, 26, 31],
        [45, 48, 0, 53, 34, 46, 43, 34, 39],
        [42, 45, 53, 0, 31, 43, 40, 31, 36],
        [23, 26, 34, 31, 0, 24, 21, 12, 17],
        [35, 38, 46, 43, 24, 0, 33, 24, 29],
        [32, 35, 43, 40, 21, 33, 0, 21, 26],
        [23, 26, 34, 31, 12, 24, 21, 0, 17],
        [28, 31, 39, 36, 17, 29, 26, 17, 0]]

costsRAIL = [[0, 162, 203, 214, 238, 262, 283, 348, 355],
        [162, 0, 173, 184, 208, 232, 253, 321, 327],
        [203, 173, 0, 152, 174, 198, 219, 287, 293],
        [214, 184, 152, 0, 155, 182, 200, 269, 275],
        [238, 208, 174, 155, 0, 165, 176, 244, 251],
        [262, 232, 198, 182, 165, 0, 158, 223, 229],
        [283, 253, 219, 200, 176, 158, 0, 202, 208],
        [348, 321, 287, 269, 244, 223, 202, 0, 141],
        [355, 327, 293, 275, 251, 229, 208, 141, 0]]

VOTcostRAIL = [[0, 4, 6, 7, 9, 10, 12, 17, 18],
        [4, 0, 5, 6, 8, 10, 12, 16, 17],
        [6, 5, 0, 3, 4, 6, 8, 12, 13],
        [7, 6, 3, 0, 3, 5, 6, 10, 12],
        [9, 8, 4, 3, 0, 4, 5, 10, 12],
        [10, 10, 6, 5, 4, 0, 4, 8, 9],
        [12, 12, 8, 6, 5, 4, 0, 7, 8],
        [17, 16, 12, 11, 10, 8, 7, 0, 4],
        [18, 17, 13, 12, 11, 9, 8, 4, 0]]

accRAIL = [[0, 6, 15, 9, 7, 7, 11, 9, 11],
        [6, 0, 11, 5, 3, 3, 7, 5, 7],
        [15, 11, 0, 14, 12, 12, 16, 14, 16],
        [9, 5, 14, 0, 6, 6, 10, 8, 10],
        [7, 3, 12, 6, 0, 4, 8, 6, 8],
        [7, 3, 12, 6, 4, 0, 8, 6, 8],
        [11, 7, 16, 10, 8, 8, 0, 10, 12],
        [9, 5, 14, 8, 6, 6, 10, 0, 10],
        [11, 7, 16, 10, 8, 8, 12, 10, 0]]

freqRAIL = [[0, 0, 78, 5, 0, 7, 26, 5, 19],
        [0, 0, 0, 0, 0, 0, 0, 0, 0],
        [78, 0, 0, 2, 0, 0, 20, 30, 19],
        [5, 0, 2, 0, 0, 0, 0, 10, 20],
        [0, 0, 0, 0, 0, 0, 0, 0, 0],
        [7, 0, 0, 0, 0, 0, 0, 1, 0],
        [26, 0, 20, 0, 0, 0, 0, 0, 0],
        [5, 0, 30, 10, 0, 1, 0, 0, 10],
        [19, 0, 19, 20, 0, 0, 0, 10, 0]]

VOTcostIWT = [[0, 23, 32, 39, 49, 57, 63, 86, 88],
        [55, 0, 20, 27, 36, 44, 50, 73, 75],
        [62, 17, 0, 17, 26, 34, 40, 63, 65],
        [67, 22, 17, 0, 20, 28, 34, 56, 58],
        [74, 29, 26, 20, 0, 18, 24, 47, 49],
        [80, 35, 34, 28, 18, 0, 15, 38, 40],
        [85, 40, 39, 34, 24, 15, 0, 35, 36],
        [102, 66, 63, 56, 47, 38, 35, 0, 12],
        [103, 68, 65, 58, 49, 40, 36, 12, 0]]

acc = [[0, 6, 17, 8, 7, 7, 9, 5, 7],
        [6, 0, 13, 4, 3, 3, 5, 1, 3],
        [17, 13, 0, 15, 14, 14, 16, 12, 14],
        [8, 4, 15, 0, 5, 5, 7, 3, 5],
        [7, 3, 14, 5, 0, 4, 6, 2, 4],
        [7, 3, 14, 5, 4, 0, 6, 2, 4],
        [9, 5, 16, 7, 6, 6, 0, 4, 6],
        [5, 1, 12, 3, 2, 2, 4, 0, 2],
        [7, 3, 14, 5, 4, 4, 6, 2, 0]]

portif = [[0, 1, 1, 1, 1, 1, 1, 1, 1],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0, 0, 0]]

Twaitport = [30, 1, 1, 1, 1, 1, 1, 1, 1]
listODs = []

for idx, x in enumerate(terminals):
    for idy, y in enumerate(terminals):
        if idx != idy:
            listODs.append(ODpair(x,y,OD_matrix_allM[idx][idy]*demand_factor,costsROAD[idx][idy],VOTcostROAD[idx][idy],accROAD[idx][idy],costsRAIL[idx][idy],VOTcostRAIL[idx][idy],accRAIL[idx][idy],freqRAIL[idx][idy],VOTcostIWT[idx][idy],acc[idx][idy],portif[idx][idy]))

mynetwork=Network(terminals, Twaitport, listODs)
print(len(listODs))

profitsHistory=[]
iterat=0

myuD=Utility(utype, 2.06, 0.338, 1.49, 0.0229, 0.0469, 0.141, -4.81)
myuC=Utility(utype, 0, 0, 0, 0, 0, 0, -10000)

fleet1=Fleet([Vessel("M8",180,168),Vessel("M11",300,168)],fleetsize1)
fleet2=Fleet([Vessel("M8",180,168),Vessel("M11",300,168)],fleetsize2)

if ucase == "D-D":
    iwtop1=IWToperator(mynetwork, fleet1, myuD, Ocosts, Vcosts, Tsailod)
    iwtop2=IWToperator(mynetwork, fleet2, myuD, Ocosts, Vcosts, Tsailod)
    results1=iwtop1.solveSNDP(method, otheriwtprices, otheriwtfreqs, 1, -5.76, 10000, 10000, 111)
    results2=iwtop2.solveSNDP(method, otheriwtprices, otheriwtfreqs, 1, -5.76, 10000, 10000, 222)
if ucase == "D-C":
    iwtop1=IWToperator(mynetwork, fleet1, myuD, Ocosts, Vcosts, Tsailod)
    iwtop2=IWToperator(mynetwork, fleet2, myuC, Ocosts, Vcosts, Tsailod)
    results1=iwtop1.solveSNDP(method, otheriwtprices, otheriwtfreqs, 1, -5.76, 10000, 10000, 111)
    results2=iwtop2.solveSNDP(method, otheriwtprices, otheriwtfreqs, 1, -10000, 10000, 10000, 222)
if ucase == "C-D":
    iwtop1=IWToperator(mynetwork, fleet1, myuC, Ocosts, Vcosts, Tsailod)
    iwtop2=IWToperator(mynetwork, fleet2, myuD, Ocosts, Vcosts, Tsailod)
    results1=iwtop1.solveSNDP(method, otheriwtprices, otheriwtfreqs, 1, -10000, 10000, 10000, 111)
    results2=iwtop2.solveSNDP(method, otheriwtprices, otheriwtfreqs, 1, -5.76, 10000, 10000, 222)
if ucase == "C-C":
    iwtop1=IWToperator(mynetwork, fleet1, myuC, Ocosts, Vcosts, Tsailod)
    iwtop2=IWToperator(mynetwork, fleet2, myuC, Ocosts, Vcosts, Tsailod)
    results1=iwtop1.solveSNDP(method, otheriwtprices, otheriwtfreqs, 1, -10000, 10000, 10000, 111)
    results2=iwtop2.solveSNDP(method, otheriwtprices, otheriwtfreqs, 1, -10000, 10000, 10000, 222)

utilpop=Utility('Mixed', 2.30, 0.713, 1.63, 0.0278, 0.0530, 0.157, -8.68)
n_shippers=np.full((len(terminals), len(terminals)), 10000)
mypop=Population(mynetwork, utilpop, 2.30, 4682, n_shippers, 0.69)
assignment=mypop.assignCargo(np.copy(results1['Prices']), np.copy(results2['Prices']), results1['FreqsOD'], results2['FreqsOD'],np.copy(results1['CapsOD']),np.copy(results2['CapsOD']))
print(assignment)
profit1=round(iwtop1.computeActProfits(assignment['IWT1']),3)
profit2=round(iwtop2.computeActProfits(assignment['IWT2']),3)

logfile = open(instancename+'.txt', 'w')
logfileopti = open(instancename+'OPTI'+'.txt', 'w')
logfileprice = open(instancename+'PRICE'+'.txt', 'w')
logfilefreq = open(instancename+'FREQ'+'.txt', 'w')

while (not (profit1,profit2) in profitsHistory):
    print((profit1,profit2))
    logfile.write(str(profit1)+','+str(profit2)+' \n')
    logfileopti.write(str(results1['Profits'])+','+str(results2['Profits'])+' \n')
    logfileprice.write(str(iwtop1.pricesOD[0][1])+','+str(iwtop1.pricesOD[1][0])+','+str(iwtop2.pricesOD[0][1])+','+str(iwtop2.pricesOD[1][0])+' \n')
    logfilefreq.write(str(iwtop1.getFreqOD()[0][1])+','+str(iwtop1.getFreqOD()[1][0])+','+str(iwtop2.getFreqOD()[0][1])+','+str(iwtop2.getFreqOD()[1][0])+' \n')
    profitsHistory.append((profit1,profit2))
    writeExcelFile(iwtop1,iwtop2,assignment,instancename+str(iterat))
    iterat+=1
    if (ucase == "D-D" or ucase == "D-C"):
        results1=iwtop1.solveSNDP(method, 0, 0, 1, -5.76, boundp, boundf, 111, 0, assignment['IWT1'], assignment['IWT2'], {ke: assignment[ke] for ke in ('ROAD','RAIL')})
    else:
        results1=iwtop1.solveSNDP(method, 0, 0, 1, -10000, boundp, boundf, 111, 0, assignment['IWT1'], assignment['IWT2'], {ke: assignment[ke] for ke in ('ROAD','RAIL')})
    assignment=mypop.assignCargo(np.copy(results1['Prices']), np.copy(results2['Prices']), results1['FreqsOD'], results2['FreqsOD'],np.copy(results1['CapsOD']),np.copy(results2['CapsOD']))
    profit1=round(iwtop1.computeActProfits(assignment['IWT1']),3)
    profit2=round(iwtop2.computeActProfits(assignment['IWT2']),3)
    print(assignment)
#     if (not (profit1,profit2) in profitsHistory):
    print((profit1,profit2))
    logfile.write(str(profit1)+','+str(profit2)+' \n')
    logfileopti.write(str(results1['Profits'])+','+str(results2['Profits'])+' \n')
    logfileprice.write(str(iwtop1.pricesOD[0][1])+','+str(iwtop1.pricesOD[1][0])+','+str(iwtop2.pricesOD[0][1])+','+str(iwtop2.pricesOD[1][0])+' \n')
    logfilefreq.write(str(iwtop1.getFreqOD()[0][1])+','+str(iwtop1.getFreqOD()[1][0])+','+str(iwtop2.getFreqOD()[0][1])+','+str(iwtop2.getFreqOD()[1][0])+' \n')
    profitsHistory.append((profit1,profit2))
    if (ucase == "D-D" or ucase == "C-D"):
        results2=iwtop2.solveSNDP(method, 0, 0, 1, -5.76, boundp, boundf, 222, 0, assignment['IWT2'], assignment['IWT1'], {ke: assignment[ke] for ke in ('ROAD','RAIL')})
    else:
        results2=iwtop2.solveSNDP(method, 0, 0, 1, -10000, boundp, boundf, 222, 0, assignment['IWT2'], assignment['IWT1'], {ke: assignment[ke] for ke in ('ROAD','RAIL')})
    assignment=mypop.assignCargo(np.copy(results1['Prices']), np.copy(results2['Prices']), results1['FreqsOD'], results2['FreqsOD'],np.copy(results1['CapsOD']),np.copy(results2['CapsOD']))
    profit1=round(iwtop1.computeActProfits(assignment['IWT1']),3)
    profit2=round(iwtop2.computeActProfits(assignment['IWT2']),3)
    print(assignment)

#     if (not (profit1,profit2) in profitsHistory):
#         print((profit1,profit2))
#         logfile.write(str(profit1)+','+str(profit2)+' \n')
#         logfileopti.write(str(results1['Profits'])+','+str(results2['Profits'])+' \n')
#         logfileprice.write(str(iwtop1.pricesOD[0][1])+','+str(iwtop1.pricesOD[1][0])+','+str(iwtop2.pricesOD[0][1])+','+str(iwtop2.pricesOD[1][0])+' \n')
#         logfilefreq.write(str(iwtop1.getFreqOD()[0][1])+','+str(iwtop1.getFreqOD()[1][0])+','+str(iwtop2.getFreqOD()[0][1])+','+str(iwtop2.getFreqOD()[1][0])+' \n')
#         profitsHistory.append((profit1,profit2))
#         if (ucase == "D-D" or ucase == "C-D"):
#             results2=iwtop2.solveSNDP(method, 0, 0, 10, -5.76, boundp, boundf, 222, 0, assignment['IWT2'], assignment['IWT1'], {ke: assignment[ke] for ke in ('ROAD','RAIL')})
#         else:
#             results2=iwtop2.solveSNDP(method, 0, 0, 10, -10000, boundp, boundf, 222, 0, assignment['IWT2'], assignment['IWT1'], {ke: assignment[ke] for ke in ('ROAD','RAIL')})
#         assignment=mypop.assignCargo(np.copy(results1['Prices']), np.copy(results2['Prices']), results1['FreqsOD'], results2['FreqsOD'],np.copy(results1['CapsOD']),np.copy(results2['CapsOD']))
#         profit1=round(iwtop1.computeActProfits(assignment['IWT1']),3)
#         profit2=round(iwtop2.computeActProfits(assignment['IWT2']),3)
#         print(assignment)
#     if (not (profit1,profit2) in profitsHistory):
#         print((profit1,profit2))
#         logfile.write(str(profit1)+','+str(profit2)+' \n')
#         logfileopti.write(str(results1['Profits'])+','+str(results2['Profits'])+' \n')
#         logfileprice.write(str(iwtop1.pricesOD[0][1])+','+str(iwtop1.pricesOD[1][0])+','+str(iwtop2.pricesOD[0][1])+','+str(iwtop2.pricesOD[1][0])+' \n')
#         logfilefreq.write(str(iwtop1.getFreqOD()[0][1])+','+str(iwtop1.getFreqOD()[1][0])+','+str(iwtop2.getFreqOD()[0][1])+','+str(iwtop2.getFreqOD()[1][0])+' \n')
#         profitsHistory.append((profit1,profit2))
#         if (ucase == "D-D" or ucase == "D-C"):
#             results1=iwtop1.solveSNDP(method, 0, 0, 10, -5.76, boundp, boundf, 111, 0, assignment['IWT1'], assignment['IWT2'], {ke: assignment[ke] for ke in ('ROAD','RAIL')})
#         else:
#             results1=iwtop1.solveSNDP(method, 0, 0, 10, -10000, boundp, boundf, 111, 0, assignment['IWT1'], assignment['IWT2'], {ke: assignment[ke] for ke in ('ROAD','RAIL')})
#         assignment=mypop.assignCargo(np.copy(results1['Prices']), np.copy(results2['Prices']), results1['FreqsOD'], results2['FreqsOD'],np.copy(results1['CapsOD']),np.copy(results2['CapsOD']))
#         profit1=round(iwtop1.computeActProfits(assignment['IWT1']),3)
#         profit2=round(iwtop2.computeActProfits(assignment['IWT2']),3)
#         print(assignment)

print((profit1,profit2))
logfile.write(str(profit1)+','+str(profit2)+' \n')
logfileopti.write(str(results1['Profits'])+','+str(results2['Profits'])+' \n')
logfileprice.write(str(iwtop1.pricesOD[0][1])+','+str(iwtop1.pricesOD[1][0])+','+str(iwtop2.pricesOD[0][1])+','+str(iwtop2.pricesOD[1][0])+' \n')
logfilefreq.write(str(iwtop1.getFreqOD()[0][1])+','+str(iwtop1.getFreqOD()[0][1])+','+str(iwtop2.getFreqOD()[0][1])+','+str(iwtop2.getFreqOD()[1][0])+' \n')
writeExcelFile(iwtop1,iwtop2,assignment,instancename)
logfile.close()
logfileopti.close()
logfileprice.close()
logfilefreq.close()
