% for plotting results 
load Sherry_color Sherry_color
%% data sets 
% 0 + 0
load INDI_MLA_QP_virtual_Shear0_Bend0_smartx01-Sep-2020-18-40-38
% 20 + 0
% load INDI_MLA_QP_virtual_Shear20_Bend0_smartx01-Sep-2020-18-43-42
load INDI_MLA_QP_virtual_Shear20_Bend0_smartx01-Sep-2020-18-48-07
% load INDI_MLA_QP_virtual_Shear20_Bend0_smartx01-Sep-2020-18-50-47
% 25 + 0
load INDI_MLA_QP_virtual_Shear25_Bend0_smartx01-Sep-2020-19-28-08
% load INDI_MLA_QP_virtual_Shear25_Bend0_smartx01-Sep-2020-19-30-29
% load INDI_MLA_QP_virtual_Shear25_Bend0_smartx01-Sep-2020-19-32-52
% 30 + 0
% load INDI_MLA_QP_virtual_Shear30_Bend0_smartx01-Sep-2020-18-54-15
% load INDI_MLA_QP_virtual_Shear30_Bend0_smartx01-Sep-2020-18-56-33
load INDI_MLA_QP_virtual_Shear30_Bend0_smartx01-Sep-2020-18-58-54
% 35 +0 
% load INDI_MLA_QP_virtual_Shear35_Bend0_smartx01-Sep-2020-19-02-50
% load INDI_MLA_QP_virtual_Shear35_Bend0_smartx01-Sep-2020-19-05-34
load INDI_MLA_QP_virtual_Shear35_Bend0_smartx01-Sep-2020-19-09-03
% 50 + 30
% load INDI_MLA_QP_virtual_Shear50_Bend30_smartx01-Sep-2020-19-12-35
% load INDI_MLA_QP_virtual_Shear50_Bend30_smartx01-Sep-2020-19-14-53
load INDI_MLA_QP_virtual_Shear50_Bend30_smartx01-Sep-2020-19-17-10
% 60 + 30
% load INDI_MLA_QP_virtual_Shear60_Bend30_smartx01-Sep-2020-19-20-14
% load INDI_MLA_QP_virtual_Shear60_Bend30_smartx01-Sep-2020-19-22-40
load INDI_MLA_QP_virtual_Shear60_Bend30_smartx01-Sep-2020-19-25-23
%%
n_sample = size(time,1);
dt = 0.001;
sample_interval = (10/dt+1):1:n_sample;
time_shift = 10*ones(size(sample_interval))';
new_time = time(sample_interval)-time_shift;
%% for control input 
figure 
% plot(new_time,control_input(sample_interval,:))
set (gcf,'Position',[2204 411 560 315])
for i = 1:1:12
    plot(new_time,control_input(sample_interval,i),'color',Sherry_color(i,:))
    hold on
end
grid on 
ylabel('servo angles [deg]')
xlabel('time [s]')
legend_str = {'act1','act2','act3','act4','act5','act6','act7','act8','act9','act10','act11','act12'};
l = legend(legend_str,'Location','northwest','NumColumns',6);
set(l,'Position',[ 0.1423    0.8741    0.8179    0.1159])
%% for control input with constrain 
figure 
set (gcf,'Position',[2204 411 560 315])
for i = 1:1:12
    plot(new_time,control_input(sample_interval,i),'color',Sherry_color(i,:))
    hold on
end
grid on 
plot(new_time,30.*ones(size(new_time)),'--','color',[1,0,0],'linewidth',1)
plot(new_time,-30.*ones(size(new_time)),'-.','color',[1,0,0],'linewidth',1)

ylabel('servo angles [deg]')
xlabel('time [s]')
set(gca,'position',[ 0.0982    0.14    0.8643    0.7])
legend_str = {'act1','act2','act3','act4','act5','act6','act7','act8',...
    'act9','act10','act11','act12','max','min'};
l = legend(legend_str,'Location','northwest','NumColumns',7);
set(l,'Position',[ 0.10    0.8741    0.8179    0.1159])
ylim([-35,35])
%% for balance filtered  with command 
figure
set (gcf,'Position',[2204 411 560 315])
h1 = subplot(2,1,1);
set(h1,'position',[0.0929    0.5492   0.8661    0.353])
plot(new_time,command(sample_interval,1))
hold on 
plot(new_time,balance_filtered(sample_interval,1),'-.')
grid on 
ylabel('F_y [N]')
% xlabel('time [s]')
l = legend('command','INDI-QP-V');
set(l,'Orientation','horizontal')
set(l,'Position',[0.3613    0.9167    0.3232    0.0571])

h2 = subplot(2,1,2);
set(h2,'position',[0.0929     0.1195    0.8661    0.353])
plot(new_time,command(sample_interval,2))
hold on 
plot(new_time,balance_filtered(sample_interval,2),'-.')
grid on 
ylabel('M_x [Nm]')
xlabel('time [s]')
%% for balance filtered  without command 
figure
subplot(2,1,1)
plot(new_time,balance_filtered(sample_interval,1))
grid on 
ylabel('F_y [N]')
xlabel('time [s]')
subplot(2,1,2)
plot(new_time,balance_filtered(sample_interval,2))
grid on 
ylabel('M_x [Nm]')
xlabel('time [s]')

%% QP output   35 0 
figure
set (gcf,'Position',[2204 411 560 280])
h1 = subplot(2,1,1);
set(h1,'position',[0.0929    0.59   0.8661    0.38])
plot(new_time,QP_output(sample_interval,1))
hold on 
plot(new_time,QP_output(sample_interval,2),'-.')
grid on 
ylabel('Allocation Error')
% xlabel('time [s]')
l = legend('F_y','M_x');
set(l,'Orientation','horizontal','location','northwest')
% set(l,'Position',[0.3613    0.9167    0.3232    0.0571])
iteration = QP_output(sample_interval,8);
% for i = 1:1:size(iteration)
%     if iteration(i) > 10
%         iteration(i) = 10;
%     end
% end

h2 = subplot(2,1,2);
set(h2,'position',[0.0929     0.13    0.8661    0.38])
plot(new_time,iteration)
grid on 
ylabel('Number of Iterations')
xlabel('time [s]')

%% QP output   60 30 
figure
set (gcf,'Position',[2204 411 560 280])
h1 = subplot(2,1,1);
set(h1,'position',[0.0929    0.57   0.8661    0.36])
plot(new_time,QP_output(sample_interval,1))
hold on 
plot(new_time,QP_output(sample_interval,2),'-.')
grid on 
ylabel('Allocation Error')
% xlabel('time [s]')
l = legend('F_y','M_x');
set(l,'Orientation','horizontal','location','northwest')
% set(l,'Position',[0.3613    0.9167    0.3232    0.0571])
iteration = QP_output(sample_interval,8);
% for i = 1:1:size(iteration)
%     if iteration(i) > 10
%         iteration(i) = 10;
%     end
% end

h2 = subplot(2,1,2);
set(h2,'position',[0.0929     0.13    0.8661    0.36])
plot(new_time,iteration)
grid on 
ylabel('Number of Iterations')
xlabel('time [s]')
%%
% error Gu - niu 
figure 
plot(new_time,QP_output(sample_interval,[1,2]))

% iteration time 
figure 
plot(new_time,QP_output(sample_interval,8))

% flag
figure 
plot(new_time,QP_output(sample_interval,9))


