# Overview of Simulation Models and Online Repositories

## Rijk Mercuur

## November 10, 2020

The dissertation ‘Simulating Human Routines: Integrating Social Practice Theory in Agent-
Based Models’ used simulation models throughout the thesis. This document gives an overview of
where these models are found. The models are stored in one place to avoid confusion about the
most recent model. The models are stored in GitHub to enable fast-updating, version history and
collaboration.

## 1 Social Practice Agent Framework and Applications

The Social Practice Agent framework modelled in Repast and OWL. The framework is available as
a template. Two specific models used based on earlier versions on SoPrA are used in the thesis.

```
Table 1: Overview of the online repositories for the SoPrA framework.
```
| Title                                          | Ch. | Link                                                                                                  |
|------------------------------------------------|:-----:|-------------------------------------------------------------------------------------------------------:|
|Most Recent SoPra Framework (Repast, OWL) |4| https:://github.com/rmercuur/SoPrA-Models|
|Older Version (OWL) |6 |https:://github.com/rmercuur/SOPRA|
|Older version (Repast) |8 |https:://github.com/rmercuur/HabitsTraffic|

## 2 Ultimatum Game Simulation Models

Models that simulate the behaviour of a homo economicus agent, a value-based agent and a norm
based agent in a psychological experiment called the ultimatum game.

```
Table 2: Overview of the online repositories for the Ultimatum Game simulation models.
```
| Title                                          | Ch. | Link                                                                                                  |
|------------------------------------------------|:-----:|-------------------------------------------------------------------------------------------------------:|
|Most Recent UG Simulation (Repast) |5| https:://github.com/rmercuur/moral-ultimatum-game|
|Older Version UG Simulation (Repast) |2| https:://github.com/rmercuur/UltimateValuesEclipse|
|Value-Based Agent Model (R) |2 |https:://github.com/rmercuur/UltimatValuesR|
|ML Model (Matlab) and Data Analysis (R)| 5 |https:://github.com/rmercuur/moral-ultimatum-game|


