import { AxiosRequestConfig } from 'axios';

export interface User {
    id: string;
    first_name: string;
    last_name: string;
    email: string;
    email_verified_at: string | null;
    role: string;
    project_role?: string;
}

export interface Project {
    id: string;
    name: string;
    created_at: string;
    user_role?: string;
}

export interface KeyDriver {
    id: string;
    project_id: string;
    name: string;
    items?: DriverItem[];
}

export interface DriverItem {
    id: string;
    key_driver_id: string;
    name: string;
    range: boolean;
    max: number | null;
    min: number | null;
    records: ItemRecord[];
}

export interface ItemRecord {
    id: string;
    driver_item_id: string;
    date: string;
    max: number;
    min: number | null;
    type: 'normal' | 'decision' | 'risk' | 'constraint' | 'test';
    comments: string | null;
    attachments: string[] | null;
}

export interface InputOption {
    value: string;
    label: string;
}

export interface PaginationMeta {
    current_page: number;
    from: number;
    last_page: number;
    to: number;
    total: number;
}

export interface PsdmRequestConfig extends AxiosRequestConfig {
    hideMessage?: boolean;
    scope?: string;
}
