import { RouteRecordRaw } from 'vue-router';

const routes: Array<RouteRecordRaw> = [
    {
        path: '/',
        redirect: '/signin',
    },
    {
        path: '/signin',
        name: 'SignIn',
        meta: { guard: 'guest' },
        component: () => import('@/views/SignIn.vue'),
    },
    {
        path: '/signup',
        name: 'SignUp',
        meta: { guard: 'guest' },
        component: () => import('@/views/SignUp.vue'),
    },
    {
        path: '/password/forgot',
        name: 'PasswordForgot',
        meta: { guard: 'guest' },
        component: () => import('@/views/PasswordForgot.vue'),
    },
    {
        path: '/password/reset/:token',
        name: 'PasswordReset',
        meta: { guard: 'guest' },
        component: () => import('@/views/PasswordReset.vue'),
    },
    {
        path: '/email/verify/:id/:hash',
        name: 'EmailVerify',
        meta: { guard: 'auth' },
        component: () => import('@/views/EmailVerify.vue'),
    },
    {
        path: '/',
        meta: { guard: 'auth' },
        component: () => import('@/views/AuthWrapper.vue'),
        children: [
            {
                path: 'projects',
                name: 'ProjectIndex',
                component: () => import('@/views/ProjectIndex.vue'),
            },
            {
                path: 'projects/:project',
                name: 'ProjectShow',
                component: () => import('@/views/ProjectShow.vue'),
            },
            {
                path: 'account',
                name: 'AccountIndex',
                component: () => import('@/views/AccountIndex.vue'),
            },
            {
                path: '/:pathMatch(.*)*',
                name: 'AuthNotFound',
                component: () => import('@/views/NotFound.vue'),
            },
        ],
    },
    {
        path: '/:pathMatch(.*)*',
        name: 'NotFound',
        component: () => import('@/views/NotFound.vue'),
    },
];

export default routes;
