import routes from '@/router/routes';
import { useAuthStore } from '@/stores/auth';
import { useValidationStore } from '@/stores/validation';
import { createRouter, createWebHistory } from 'vue-router';

const router = createRouter({
    history: createWebHistory(),
    routes,
});

router.beforeEach((to, _from, next) => {
    const authStore = useAuthStore();

    const validationStore = useValidationStore();

    if (to.meta.guard === 'guest' && authStore.user !== null) {
        next('/projects');
        return;
    }

    if (to.meta.guard === 'auth' && authStore.user === null) {
        next('/signin');
        return;
    }
    next();

    validationStore.bags = {};
});

export default router;
