import router from '@/router';
import { useAuthStore } from '@/stores/auth';
import { useValidationStore } from '@/stores/validation';
import { PsdmRequestConfig } from '@/types';
import axios from 'axios';

export const psdmApi = axios.create({
    baseURL: import.meta.env.VITE_PSDM_API_URL,
    headers: {
        'X-Requested-With': 'XMLHttpRequest',
        'Content-Type': 'application/json',
    },
    withCredentials: true,
});

export const setPsdmInterceptors = () => {
    const authStore = useAuthStore();
    const validationStore = useValidationStore();

    psdmApi.interceptors.response.use(
        (response) => {
            const config = response.config as PsdmRequestConfig;

            if (response.data.message && config.hideMessage !== true) {
                validationStore.addNotification(response.data.message, 'success');
            }

            return response;
        },
        ({ response }) => {
            const config = response.config as PsdmRequestConfig;

            if (response.status === 401) {
                authStore.removeUser();
                psdmApi.get(`/csrf-cookie`);
                router.push(`/signin`);
            }

            if (response.status === 422 && response.data.errors) {
                validationStore.addBag(response.data.errors, config.scope);
            }

            if (response.data.message && config.hideMessage !== true) {
                validationStore.addNotification(response.data.message, 'error');
            }

            return response;
        },
    );

    psdmApi.get(`/csrf-cookie`);
};
