import { defineStore } from 'pinia';
import { User } from '@/types';
import { psdmApi } from '@/api/psdmApi';
import router from '@/router';

interface State {
    user: User | null;
}

const userKey = import.meta.env.VITE_USER_STORAGE_KEY;

export const useAuthStore = defineStore('auth', {
    state: (): State => ({
        user: localStorage[userKey] ? JSON.parse(localStorage[userKey]) : null,
    }),
    actions: {
        removeUser() {
            this.user = null;
            localStorage.removeItem(userKey);
        },
        setUser(user: User) {
            this.user = user;
            localStorage.setItem(userKey, JSON.stringify(user));
        },
        async signOut() {
            await psdmApi.post(`/signout`);
            await psdmApi.get(`/csrf-cookie`);
            this.removeUser();
            router.push('/signin');
        },
    },
});
