import { ScriptableContext } from 'chart.js';

const backgrounds = {
    normal: '#6b7280',
    risk: '#ef4444',
    decision: '#84cc16',
    constraint: '#f59e0b',
    test: '#3b82f6',
};

const borders = {
    normal: '#d1d5db',
    risk: '#fca5a5',
    decision: '#bef264',
    constraint: '#fcd34d',
    test: '#93c5fd',
};

export function usePoint() {
    const setPointBackgroundColor = (context: ScriptableContext<'line'>) => {
        // @ts-ignore
        return backgrounds[context.raw.type];
    };

    const setPointBorderColor = (context: ScriptableContext<'line'>) => {
        // @ts-ignore
        return borders[context.raw.type];
    };

    const setPointRadius = (context: ScriptableContext<'line'>) => {
        // @ts-ignore;
        return context.raw.type === 'normal' ? 5 : 7;
    };

    const setPointStyle = (context: ScriptableContext<'line'>) => {
        // @ts-ignore
        return context.raw.type === 'normal' ? 'circle' : 'rectRot';
    };

    return { setPointBorderColor, setPointBackgroundColor, setPointRadius, setPointStyle };
}
